/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.shade147.converters.reflection;

import com.thoughtworks.xstream.shade147.converters.reflection.FieldDictionary;
import com.thoughtworks.xstream.shade147.converters.reflection.ObjectAccessException;
import com.thoughtworks.xstream.shade147.converters.reflection.PureJavaReflectionProvider;
import java.lang.reflect.Field;
import sun.misc.Unsafe;

public class SunLimitedUnsafeReflectionProvider
extends PureJavaReflectionProvider {
    protected static final Unsafe unsafe;
    protected static final Exception exception;

    public SunLimitedUnsafeReflectionProvider() {
    }

    public SunLimitedUnsafeReflectionProvider(FieldDictionary fieldDictionary) {
        super(fieldDictionary);
    }

    public Object newInstance(Class type) {
        if (exception != null) {
            throw new ObjectAccessException("Cannot construct " + type.getName(), exception);
        }
        try {
            return unsafe.allocateInstance(type);
        }
        catch (SecurityException e) {
            throw new ObjectAccessException("Cannot construct " + type.getName(), e);
        }
        catch (InstantiationException e) {
            throw new ObjectAccessException("Cannot construct " + type.getName(), e);
        }
        catch (IllegalArgumentException e) {
            throw new ObjectAccessException("Cannot construct " + type.getName(), e);
        }
    }

    protected void validateFieldAccess(Field field) {
    }

    private Object readResolve() {
        this.init();
        return this;
    }

    static {
        Unsafe u = null;
        Exception ex = null;
        try {
            Field unsafeField = Unsafe.class.getDeclaredField("theUnsafe");
            unsafeField.setAccessible(true);
            u = (Unsafe)unsafeField.get(null);
        }
        catch (SecurityException e) {
            ex = e;
        }
        catch (NoSuchFieldException e) {
            ex = e;
        }
        catch (IllegalArgumentException e) {
            ex = e;
        }
        catch (IllegalAccessException e) {
            ex = e;
        }
        exception = ex;
        unsafe = u;
    }
}

