/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.api.client.proxy;

import java.util.Objects;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.http.api.client.proxy.ProxyConfig;

class DefaultProxyConfig
implements ProxyConfig {
    private static final int MAXIMUM_PORT_NUMBER = 65535;
    private final String host;
    private final int port;
    private final String username;
    private final String password;
    private final String nonProxyHosts;

    DefaultProxyConfig(String host, int port, String username, String password, String nonProxyHosts) {
        Preconditions.checkArgument((host != null ? 1 : 0) != 0, (String)"Host must be not null");
        Preconditions.checkArgument((port <= 65535 ? 1 : 0) != 0, (String)"Port must be under 65535. Check that you set the port.");
        this.host = host;
        this.port = port;
        this.username = username;
        this.password = password;
        this.nonProxyHosts = nonProxyHosts;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public String getNonProxyHosts() {
        return this.nonProxyHosts;
    }

    public int hashCode() {
        return Objects.hash(this.host, this.port, this.password, this.username, this.nonProxyHosts);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultProxyConfig that = (DefaultProxyConfig)obj;
        return Objects.equals(this.host, that.host) && Objects.equals(this.port, that.port) && Objects.equals(this.password, that.password) && Objects.equals(this.username, that.username) && Objects.equals(this.nonProxyHosts, that.nonProxyHosts);
    }
}

