/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.api.client.auth;

import org.mule.runtime.http.api.client.auth.DefaultHttpAuthenticationBuilder;
import org.mule.runtime.http.api.client.auth.HttpAuthenticationBuilder;
import org.mule.runtime.http.api.client.auth.HttpAuthenticationType;

public interface HttpAuthentication {
    public static HttpAuthenticationBuilder builder() {
        return new DefaultHttpAuthenticationBuilder();
    }

    public static HttpAuthenticationBuilder basic(String username, String password) {
        return new DefaultHttpAuthenticationBuilder().type(HttpAuthenticationType.BASIC).username(username).password(password);
    }

    public static HttpAuthenticationBuilder digest(String username, String password) {
        return new DefaultHttpAuthenticationBuilder().type(HttpAuthenticationType.DIGEST).username(username).password(password);
    }

    public static HttpAuthenticationBuilder.HttpNtlmAuthenticationBuilder ntlm(String username, String password) {
        return HttpNtlmAuthentication.builder().username(username).password(password);
    }

    public HttpAuthenticationType getType();

    public String getUsername();

    public String getPassword();

    public boolean isPreemptive();

    public static interface HttpNtlmAuthentication
    extends HttpAuthentication {
        public static HttpAuthenticationBuilder.HttpNtlmAuthenticationBuilder builder() {
            return new DefaultHttpAuthenticationBuilder().type(HttpAuthenticationType.NTLM);
        }

        public String getDomain();

        public String getWorkstation();
    }
}

