/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.support.internal.server;

import java.io.IOException;
import java.util.Collection;
import java.util.function.Consumer;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.LifecycleException;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.RequestHandler;
import org.mule.runtime.http.api.sse.server.SseRequestContext;
import org.mule.runtime.http.support.internal.server.EndpointLifecycleHandlerWrapper;
import org.mule.runtime.http.support.internal.server.RequestHandlerWrapper;
import org.mule.runtime.http.support.internal.server.ServerAddressWrapper;
import org.mule.runtime.http.support.internal.server.SseClientWrapper;
import org.mule.runtime.http.support.internal.server.SseEndpointManagerWrapper;
import org.mule.runtime.http.support.internal.server.SseRequestContextWrapper;
import org.mule.sdk.api.http.HttpConstants;
import org.mule.sdk.api.http.server.EndpointLifecycleHandler;
import org.mule.sdk.api.http.server.ServerAddress;
import org.mule.sdk.api.http.sse.server.SseClient;
import org.mule.sdk.api.http.sse.server.SseEndpointManager;

public class HttpServerWrapper
implements org.mule.sdk.api.http.server.HttpServer {
    private final HttpServer delegate;
    private final ServerAddress serverAddress;

    public HttpServerWrapper(HttpServer delegate) {
        this.delegate = delegate;
        this.serverAddress = new ServerAddressWrapper(delegate.getServerAddress());
    }

    public void start() throws MuleException {
        try {
            this.delegate.start();
        }
        catch (IOException e) {
            throw new LifecycleException((Throwable)e, (Object)this);
        }
    }

    public void stop() {
        this.delegate.stop();
    }

    public void dispose() {
        this.delegate.dispose();
    }

    public ServerAddress getServerAddress() {
        return this.serverAddress;
    }

    public HttpConstants.Protocol getProtocol() {
        return HttpConstants.Protocol.valueOf((String)this.delegate.getProtocol().name());
    }

    public boolean isStopping() {
        return this.delegate.isStopping();
    }

    public boolean isStopped() {
        return this.delegate.isStopped();
    }

    public void enableTls(TlsContextFactory tlsContextFactory) {
        this.delegate.enableTls(tlsContextFactory);
    }

    public void disableTls() {
        this.delegate.disableTls();
    }

    public EndpointLifecycleHandler addRequestHandler(Collection<String> methods, String path, org.mule.sdk.api.http.server.RequestHandler requestHandler) {
        return new EndpointLifecycleHandlerWrapper(this.delegate.addRequestHandler(methods, path, (RequestHandler)new RequestHandlerWrapper(requestHandler)));
    }

    public EndpointLifecycleHandler addRequestHandler(String path, org.mule.sdk.api.http.server.RequestHandler requestHandler) {
        return new EndpointLifecycleHandlerWrapper(this.delegate.addRequestHandler(path, (RequestHandler)new RequestHandlerWrapper(requestHandler)));
    }

    public SseEndpointManager sse(String ssePath, Consumer<org.mule.sdk.api.http.sse.server.SseRequestContext> onRequest, Consumer<SseClient> onClient) {
        return new SseEndpointManagerWrapper(this.delegate.sse(ssePath, ctx -> onRequest.accept(new SseRequestContextWrapper((SseRequestContext)ctx)), sseClient -> onClient.accept(new SseClientWrapper((org.mule.runtime.http.api.sse.server.SseClient)sseClient))));
    }
}

