/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.support.internal.client;

import java.util.function.Consumer;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.client.HttpRequestOptionsBuilder;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.sse.client.SseRetryConfig;
import org.mule.runtime.http.api.sse.client.SseSourceConfig;
import org.mule.runtime.http.support.internal.client.HttpRequestOptionsConfigToBuilder;
import org.mule.runtime.http.support.internal.message.HttpRequestBuilderWrapper;
import org.mule.runtime.http.support.internal.message.sdktomule.HttpResponseWrapper;
import org.mule.sdk.api.http.client.HttpRequestOptionsConfigurer;
import org.mule.sdk.api.http.domain.message.response.HttpResponse;
import org.mule.sdk.api.http.sse.client.SseSourceConfigurer;

public class SseSourceConfigImpl
implements SseSourceConfigurer {
    private HttpResponse response;
    private String url;
    private boolean allowRetryDelayOverride;
    private long initialRetryDelayMillis;
    private boolean shouldRetryOnStreamEnd;
    private Consumer<org.mule.sdk.api.http.domain.message.request.HttpRequestBuilder> requestCustomizer;
    private Consumer<HttpRequestOptionsConfigurer> requestOptionsConfigConsumer;
    private boolean preserveHeadersCase;

    public SseSourceConfigurer withResponse(HttpResponse response) {
        this.response = response;
        return this;
    }

    public SseSourceConfigurer withUrl(String url) {
        this.url = url;
        return this;
    }

    public SseSourceConfigurer withAllowRetryDelayOverride(boolean allow) {
        this.allowRetryDelayOverride = allow;
        return this;
    }

    public SseSourceConfigurer withInitialRetryDelayMillis(long initialRetryDelayMillis) {
        this.initialRetryDelayMillis = initialRetryDelayMillis;
        return this;
    }

    public SseSourceConfigurer withRetry(boolean shouldRetryOnStreamEnd) {
        this.shouldRetryOnStreamEnd = shouldRetryOnStreamEnd;
        return this;
    }

    public SseSourceConfigurer withRequestCustomizer(Consumer<org.mule.sdk.api.http.domain.message.request.HttpRequestBuilder> requestCustomizer) {
        this.requestCustomizer = requestCustomizer;
        return this;
    }

    public SseSourceConfigurer withRequestOptions(Consumer<HttpRequestOptionsConfigurer> requestOptions) {
        this.requestOptionsConfigConsumer = requestOptions;
        return this;
    }

    public SseSourceConfigurer withPreserveHeadersCase(boolean preserveHeadersCase) {
        this.preserveHeadersCase = preserveHeadersCase;
        return this;
    }

    public SseSourceConfig build() {
        if (this.response == null && this.url == null) {
            throw new IllegalArgumentException("An HTTP Response or an URL must be provided to build an SseSource");
        }
        if (this.response != null) {
            return SseSourceConfig.fromResponse((org.mule.runtime.http.api.domain.message.response.HttpResponse)new HttpResponseWrapper(this.response)).build();
        }
        HttpRequestOptionsBuilder optionsBuilder = HttpRequestOptions.builder();
        if (this.requestOptionsConfigConsumer != null) {
            HttpRequestOptionsConfigToBuilder optionsConfigurer = new HttpRequestOptionsConfigToBuilder(optionsBuilder);
            this.requestOptionsConfigConsumer.accept(optionsConfigurer);
        }
        return SseSourceConfig.builder((String)this.url).withRetryConfig(new SseRetryConfig(this.allowRetryDelayOverride, this.initialRetryDelayMillis, this.shouldRetryOnStreamEnd)).withRequestCustomizer(b -> this.requestCustomizer.accept(new HttpRequestBuilderWrapper((HttpRequestBuilder)b))).withRequestOptions(optionsBuilder.build()).withPreserveHeadersCase(this.preserveHeadersCase).build();
    }
}

