/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.support.internal.client;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.client.HttpRequestOptionsBuilder;
import org.mule.runtime.http.support.internal.client.HttpRequestOptionsConfigToBuilder;
import org.mule.runtime.http.support.internal.client.SseSourceConfigImpl;
import org.mule.runtime.http.support.internal.client.SseSourceWrapper;
import org.mule.runtime.http.support.internal.message.muletosdk.HttpResponseWrapper;
import org.mule.runtime.http.support.internal.message.sdktomule.HttpRequestWrapper;
import org.mule.sdk.api.http.client.HttpClient;
import org.mule.sdk.api.http.client.HttpRequestOptionsConfigurer;
import org.mule.sdk.api.http.domain.message.request.HttpRequest;
import org.mule.sdk.api.http.domain.message.response.HttpResponse;
import org.mule.sdk.api.http.sse.client.SseSource;
import org.mule.sdk.api.http.sse.client.SseSourceConfigurer;

public class HttpClientWrapper
implements HttpClient {
    private final org.mule.runtime.http.api.client.HttpClient delegate;

    public HttpClientWrapper(org.mule.runtime.http.api.client.HttpClient delegate) {
        this.delegate = delegate;
    }

    public CompletableFuture<HttpResponse> sendAsync(HttpRequest request, Consumer<HttpRequestOptionsConfigurer> configurerConsumer) {
        HttpRequestOptionsBuilder builder = HttpRequestOptions.builder();
        HttpRequestOptionsConfigToBuilder configurer = new HttpRequestOptionsConfigToBuilder(builder);
        configurerConsumer.accept(configurer);
        HttpRequestOptions options = builder.build();
        CompletableFuture<HttpResponse> future = new CompletableFuture<HttpResponse>();
        this.delegate.sendAsync((org.mule.runtime.http.api.domain.message.request.HttpRequest)new HttpRequestWrapper(request), options).whenComplete((res, err) -> {
            if (err != null) {
                future.completeExceptionally((Throwable)err);
            } else {
                future.complete(new HttpResponseWrapper((org.mule.runtime.http.api.domain.message.response.HttpResponse)res));
            }
        });
        return future;
    }

    public SseSource sseSource(Consumer<SseSourceConfigurer> configConsumer) {
        SseSourceConfigImpl configurer = new SseSourceConfigImpl();
        configConsumer.accept(configurer);
        return new SseSourceWrapper(this.delegate.sseSource(configurer.build()));
    }

    public void start() {
        this.delegate.start();
    }

    public void stop() {
        this.delegate.stop();
    }
}

