/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.catalog.builder;

import java.net.URI;
import java.net.URISyntaxException;
import org.mule.runtime.extension.internal.loader.catalog.model.resolver.SingleTypeResolver;
import org.mule.runtime.extension.internal.loader.catalog.model.resolver.TypeResolver;

public class TypesResolverBuilder {
    private static final String JAR = "jar";
    private final URI baseUri;
    private String name;
    private String location;
    private String element;

    public TypesResolverBuilder(URI baseUri) {
        this.baseUri = baseUri;
    }

    public void name(String name) {
        this.name = name;
    }

    public void location(String location) {
        this.location = location;
    }

    public void element(String element) {
        this.element = element;
    }

    public TypeResolver build() throws Exception {
        URI schemaURI = this.baseUri != null ? this.customResolve() : new URI(this.location);
        return new SingleTypeResolver(this.name, schemaURI.toURL(), this.element);
    }

    private URI customResolve() {
        URI result;
        if (this.baseUri.getScheme().equals(JAR)) {
            try {
                URI fileCatalogBase = new URI(this.baseUri.getSchemeSpecificPart());
                URI resolvedScheme = fileCatalogBase.resolve(this.location);
                result = new URI("jar:" + resolvedScheme);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(String.format("Cannot generate a relative URI for the resource [%s] given the base URI path [%s]", this.location, this.baseUri.toString()));
            }
        } else {
            result = this.baseUri.resolve(this.location);
        }
        return result;
    }
}

