/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.util;

import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.java.api.utils.JavaTypeUtils;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.MuleExpressionLanguage;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.parameterization.ComponentParameterization;
import org.mule.runtime.core.api.util.NotAnInputStreamException;
import org.mule.runtime.module.extension.api.runtime.resolver.ParameterValueResolver;
import org.mule.runtime.module.extension.api.runtime.resolver.ValueResolvingException;
import org.mule.runtime.module.extension.internal.loader.java.property.InjectableParameterInfo;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.module.extension.internal.value.ValueProviderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InjectableParameterResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(InjectableParameterResolver.class);
    private final BindingContext expressionResolvingContext;
    private final MuleExpressionLanguage expressionManager;
    private final Map<String, InjectableParameterInfo> injectableParametersMap;

    public InjectableParameterResolver(ParameterizedModel parameterizedModel, ParameterValueResolver parameterValueResolver, MuleExpressionLanguage expressionManager, List<InjectableParameterInfo> injectableParameters) {
        this.expressionManager = expressionManager;
        this.injectableParametersMap = this.getInjectableParametersMap(injectableParameters);
        this.expressionResolvingContext = this.createBindingContext(parameterValueResolver, parameterizedModel);
    }

    public InjectableParameterResolver(ComponentParameterization<?> componentParameterization, MuleExpressionLanguage expressionManager, List<InjectableParameterInfo> injectableParameters) {
        this.expressionManager = expressionManager;
        this.injectableParametersMap = this.getInjectableParametersMap(injectableParameters);
        this.expressionResolvingContext = this.createBindingContext(componentParameterization);
    }

    public Object getInjectableParameterValue(String parameterName) {
        String string;
        Object parameterValue = null;
        InjectableParameterInfo injectableParameterInfo = this.injectableParametersMap.get(parameterName);
        if (injectableParameterInfo == null) {
            throw new IllegalArgumentException("'" + parameterName + "' is not present in the resolver");
        }
        String extractionExpression = injectableParameterInfo.getExtractionExpression();
        String topLevelRequiredParameter = this.keywordSafeName(ValueProviderUtils.getParameterNameFromExtractionExpression(extractionExpression));
        if (this.expressionResolvingContext.lookup(topLevelRequiredParameter).isPresent()) {
            try {
                parameterValue = this.expressionManager.evaluate("#[" + this.sanitizeExpression(injectableParameterInfo.getExtractionExpression()) + "]", DataType.fromType((Class)JavaTypeUtils.getType((MetadataType)injectableParameterInfo.getType())), this.expressionResolvingContext).getValue();
            }
            catch (IllegalArgumentException e) {
                LOGGER.debug(String.format("Transformation of injectable parameter '%s' failed, the same value of the resolution will be used.", parameterName), (Throwable)e);
            }
        } else {
            LOGGER.debug("The parameter: '" + topLevelRequiredParameter + "' on which the extraction expression was to be executed is not present in the context, returning null");
        }
        if (parameterValue instanceof String) {
            String stringValue = (String)parameterValue;
            string = stringValue.trim();
        } else {
            string = parameterValue;
        }
        return string;
    }

    private Map<String, InjectableParameterInfo> getInjectableParametersMap(List<InjectableParameterInfo> injectableParameters) {
        return injectableParameters.stream().collect(Collectors.toMap(InjectableParameterInfo::getParameterName, injectableParameter -> injectableParameter));
    }

    private BindingContext createBindingContext(ComponentParameterization<?> componentParameterization) {
        return this.createBindingContext((ParameterGroupModel pgm, ParameterModel pm) -> this.getParameterValueSafely(componentParameterization, (ParameterGroupModel)pgm, (ParameterModel)pm), componentParameterization.getModel());
    }

    private BindingContext createBindingContext(ParameterValueResolver parameterValueResolver, ParameterizedModel parameterizedModel) {
        return this.createBindingContext(this.getParameterValueFromParameterValueResolver(parameterValueResolver), parameterizedModel);
    }

    private BindingContext createBindingContext(BiFunction<ParameterGroupModel, ParameterModel, Object> parameterValueResolver, ParameterizedModel parameterizedModel) {
        BindingContext.Builder bindingContextBuilder = BindingContext.builder();
        for (ParameterGroupModel parameterGroupModel : parameterizedModel.getParameterGroupModels()) {
            for (ParameterModel parameterModel : parameterGroupModel.getParameterModels()) {
                Object value = parameterValueResolver.apply(parameterGroupModel, parameterModel);
                if (value == null) continue;
                if (!(value instanceof TypedValue)) {
                    String mediaType = (String)parameterModel.getType().getMetadataFormat().getValidMimeTypes().iterator().next();
                    try {
                        value = org.mule.runtime.core.api.util.IOUtils.ifInputStream((Object)value, IOUtils::toByteArray);
                    }
                    catch (NotAnInputStreamException notAnInputStreamException) {
                        // empty catch block
                    }
                    DataType valueDataType = DataType.builder().type(value.getClass()).mediaType(mediaType).build();
                    value = new TypedValue(value, valueDataType);
                }
                bindingContextBuilder.addBinding(this.keywordSafeName(parameterModel.getName()), (TypedValue)value);
            }
        }
        return bindingContextBuilder.build();
    }

    private BiFunction<ParameterGroupModel, ParameterModel, Object> getParameterValueFromParameterValueResolver(ParameterValueResolver parameterValueResolver) {
        return (parameterGroupModel, parameterModel) -> {
            String unaliasedName = IntrospectionUtils.getImplementingName(parameterModel);
            Object value = this.getParameterValueSafely(parameterValueResolver, unaliasedName);
            if (value == null) {
                value = this.getParameterValueSafely(parameterValueResolver, parameterModel.getName());
            }
            return value;
        };
    }

    private Object getParameterValueSafely(ParameterValueResolver parameterValueResolver, String parameterName) {
        try {
            return parameterValueResolver.getParameterValue(parameterName);
        }
        catch (ValueResolvingException e) {
            return null;
        }
    }

    private Object getParameterValueSafely(ComponentParameterization<?> componentParameterization, ParameterGroupModel parameterGroupModel, ParameterModel parameterModel) {
        try {
            return componentParameterization.getParameter(parameterGroupModel, parameterModel);
        }
        catch (Exception e) {
            if (e.getCause() instanceof ValueResolvingException) {
                return null;
            }
            throw e;
        }
    }

    private String keywordSafeName(String parameterName) {
        return parameterName + "_";
    }

    private String sanitizeExpression(String extractionExpression) {
        String topLevelParameter = ValueProviderUtils.getParameterNameFromExtractionExpression(extractionExpression);
        return extractionExpression.replaceFirst(topLevelParameter, this.keywordSafeName(topLevelParameter));
    }
}

