/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.source.legacy;

import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.source.PollContext;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;
import org.mule.runtime.extension.api.runtime.source.SourceCallbackContext;
import org.mule.runtime.module.extension.internal.runtime.source.legacy.SdkPollContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.source.legacy.SdkResultAdapter;
import org.mule.runtime.module.extension.internal.runtime.source.legacy.SdkSourceCallBackContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.source.legacy.SdkSourceCallbackAdapter;
import org.mule.runtime.module.extension.internal.runtime.source.legacy.SdkSourceWrapper;
import org.mule.sdk.api.runtime.source.PollingSource;
import org.mule.sdk.api.runtime.source.Source;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacySourceAdapter<T, A>
extends org.mule.runtime.extension.api.runtime.source.Source<T, A>
implements SdkSourceWrapper,
Initialisable,
Disposable {
    private static final Logger LOGGER = LoggerFactory.getLogger(LegacySourceAdapter.class);
    private final Source<T, A> delegate;

    public static <T, A> org.mule.runtime.extension.api.runtime.source.Source<T, A> from(Source<T, A> delegate) {
        if (delegate instanceof PollingSource) {
            return new LegacyPollingSourceAdapter((PollingSource)delegate);
        }
        return new LegacySourceAdapter<T, A>(delegate);
    }

    private LegacySourceAdapter(Source<T, A> delegate) {
        this.delegate = delegate;
    }

    public void onStart(SourceCallback<T, A> sourceCallback) throws MuleException {
        this.delegate.onStart(new SdkSourceCallbackAdapter<T, A>(sourceCallback));
    }

    public void onStop() {
        this.delegate.onStop();
    }

    @Override
    public Source<?, ?> getDelegate() {
        return this.delegate;
    }

    public void initialise() throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded(this.delegate);
    }

    public void dispose() {
        LifecycleUtils.disposeIfNeeded(this.delegate, (Logger)LOGGER);
    }

    private static class LegacyPollingSourceAdapter<T, A>
    extends org.mule.runtime.extension.api.runtime.source.PollingSource<T, A>
    implements SdkSourceWrapper,
    Initialisable,
    Disposable {
        private static final Logger LOGGER = LoggerFactory.getLogger(LegacyPollingSourceAdapter.class);
        private final PollingSource<T, A> delegate;

        private LegacyPollingSourceAdapter(PollingSource<T, A> delegate) {
            this.delegate = delegate;
        }

        protected void doStart() throws MuleException {
            this.delegate.onStart(null);
        }

        protected void doStop() {
            this.delegate.onStop();
        }

        public void poll(PollContext<T, A> pollContext) {
            this.delegate.poll(new SdkPollContextAdapter<T, A>(pollContext));
        }

        public void onRejectedItem(Result<T, A> result, SourceCallbackContext callbackContext) {
            this.delegate.onRejectedItem(SdkResultAdapter.from(result), (org.mule.sdk.api.runtime.source.SourceCallbackContext)new SdkSourceCallBackContextAdapter(callbackContext));
        }

        @Override
        public Source<?, ?> getDelegate() {
            return this.delegate;
        }

        public void initialise() throws InitialisationException {
            LifecycleUtils.initialiseIfNeeded(this.delegate);
        }

        public void dispose() {
            LifecycleUtils.disposeIfNeeded(this.delegate, (Logger)LOGGER);
        }
    }
}

