/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.source;

import java.util.Optional;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.parameterization.ComponentParameterization;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.extension.provider.MuleExtensionModelProvider;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.source.SourceFactoryContext;
import org.mule.runtime.module.extension.api.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.runtime.ResolverBasedComponentParameterization;
import org.mule.runtime.module.extension.internal.runtime.config.ResolverSetBasedParameterResolver;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;

public final class ResolverBasedSourceFactoryContext
implements SourceFactoryContext {
    private final ComponentParameterization<?> parameterization;
    private final ComponentLocation componentLocation;
    private final Optional<ConfigurationInstance> configurationInstance;
    private final Optional<ConnectionProvider<?>> connectionProvider;
    private final String defaultEncoding;
    private final MuleVersion runtimeVersion;

    public ResolverBasedSourceFactoryContext(SourceModel sourceModel, ComponentLocation componentLocation, ResolverSet sourceParameters, Optional<ConfigurationInstance> configurationInstance, Optional<ConnectionProvider<?>> connectionProvider, ExpressionManager expressionManager, String defaultEncoding) {
        this.componentLocation = componentLocation;
        this.configurationInstance = configurationInstance;
        this.connectionProvider = connectionProvider;
        this.defaultEncoding = defaultEncoding;
        this.runtimeVersion = MuleExtensionModelProvider.getMuleVersion();
        ResolverSetBasedParameterResolver parameterValueResolver = new ResolverSetBasedParameterResolver(sourceParameters, (ParameterizedModel)sourceModel, new ReflectionCache(), expressionManager, configurationInstance);
        this.parameterization = new ResolverBasedComponentParameterization<SourceModel>(sourceModel, parameterValueResolver);
    }

    public ComponentParameterization<?> getParameterization() {
        return this.parameterization;
    }

    public ComponentLocation getComponentLocation() {
        return this.componentLocation;
    }

    public Optional<ConfigurationInstance> getConfigurationInstance() {
        return this.configurationInstance;
    }

    public Optional<ConnectionProvider<?>> getConnectionProvider() {
        return this.connectionProvider;
    }

    public String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public MuleVersion getRuntimeVersion() {
        return this.runtimeVersion;
    }
}

