/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.authcode;

import java.lang.reflect.Field;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.extension.api.connectivity.oauth.AuthorizationCodeGrantType;
import org.mule.runtime.http.api.client.proxy.ProxyConfig;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.CustomOAuthParameters;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.OAuthConfig;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.OAuthObjectStoreConfig;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.authcode.OAuthCallbackConfig;

public final class AuthorizationCodeConfig
extends OAuthConfig<AuthorizationCodeGrantType> {
    private final String consumerKey;
    private final String consumerSecret;
    private final String authorizationUrl;
    private final String accessTokenUrl;
    private final String scope;
    private final String resourceOwnerId;
    private final String before;
    private final String after;
    private final OAuthCallbackConfig callbackConfig;
    private final AuthorizationCodeGrantType grantType;
    private final TlsContextFactory tlsContext;
    private final ProxyConfig proxyConfig;

    public AuthorizationCodeConfig(String ownerConfigName, Optional<OAuthObjectStoreConfig> storeConfig, CustomOAuthParameters customOAuthParameters, Map<Field, String> parameterExtractors, AuthorizationCodeGrantType grantType, OAuthCallbackConfig callbackConfig, String consumerKey, String consumerSecret, String authorizationUrl, String accessTokenUrl, String scope, String resourceOwnerId, String before, String after, TlsContextFactory tlsContext, ProxyConfig proxyConfig) {
        super(ownerConfigName, storeConfig, customOAuthParameters, parameterExtractors);
        this.consumerKey = consumerKey;
        this.consumerSecret = consumerSecret;
        this.authorizationUrl = authorizationUrl;
        this.accessTokenUrl = accessTokenUrl;
        this.scope = scope;
        this.resourceOwnerId = resourceOwnerId;
        this.before = before;
        this.after = after;
        this.callbackConfig = callbackConfig;
        this.grantType = grantType;
        this.tlsContext = tlsContext;
        this.proxyConfig = proxyConfig;
    }

    @Override
    public AuthorizationCodeGrantType getGrantType() {
        return this.grantType;
    }

    public String getConsumerKey() {
        return this.consumerKey;
    }

    public String getConsumerSecret() {
        return this.consumerSecret;
    }

    public String getAuthorizationUrl() {
        return this.authorizationUrl;
    }

    public String getAccessTokenUrl() {
        return this.accessTokenUrl;
    }

    public Optional<String> getScope() {
        return Optional.ofNullable(this.scope);
    }

    public String getResourceOwnerId() {
        return this.resourceOwnerId;
    }

    public Optional<String> getBefore() {
        return Optional.ofNullable(this.before);
    }

    public Optional<String> getAfter() {
        return Optional.ofNullable(this.after);
    }

    public OAuthCallbackConfig getCallbackConfig() {
        return this.callbackConfig;
    }

    public TlsContextFactory getTlsContext() {
        return this.tlsContext;
    }

    public ProxyConfig getProxyConfig() {
        return this.proxyConfig;
    }
}

