/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.config;

import jakarta.inject.Named;
import java.lang.reflect.Field;
import java.util.Collection;
import javax.inject.Inject;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.internal.lifecycle.InjectedDependenciesProvider;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.module.extension.internal.runtime.config.LifecycleAwareConfigurationProvider;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;

public class StaticConfigurationProvider
extends LifecycleAwareConfigurationProvider
implements InjectedDependenciesProvider {
    private final ConfigurationInstance configuration;

    public StaticConfigurationProvider(String name, ExtensionModel extensionModel, ConfigurationModel configurationModel, ConfigurationInstance configuration, MuleContext muleContext) {
        super(name, extensionModel, configurationModel, muleContext);
        this.configuration = configuration;
        this.registerConfiguration(configuration);
    }

    public ConfigurationInstance get(Event muleEvent) {
        return this.configuration;
    }

    public Collection<Either<Class<?>, String>> getInjectedDependencies() {
        return IntrospectionUtils.getAnnotatedFieldsStream(this.configuration.getValue().getClass(), jakarta.inject.Inject.class, Inject.class).map(field -> {
            Named name = field.getAnnotation(Named.class);
            return name != null ? Either.right((Object)name.value()) : this.javaxNamed((Field)field);
        }).toList();
    }

    private Either<Class<?>, String> javaxNamed(Field field) {
        javax.inject.Named name = field.getAnnotation(javax.inject.Named.class);
        return name != null ? Either.right((Object)name.value()) : Either.left(field.getType());
    }

    public boolean isDynamic() {
        return false;
    }
}

