/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.client;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.util.concurrent.MoreExecutors;
import jakarta.inject.Inject;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.mule.runtime.api.config.ArtifactEncoding;
import org.mule.runtime.api.config.Feature;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.api.config.MuleRuntimeFeature;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.notification.NotificationDispatcher;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.streaming.StreamingManager;
import org.mule.runtime.core.internal.util.FunctionalUtils;
import org.mule.runtime.core.privileged.exception.ErrorTypeLocator;
import org.mule.runtime.extension.api.client.ExtensionsClient;
import org.mule.runtime.extension.api.client.OperationParameterizer;
import org.mule.runtime.extension.api.client.OperationParameters;
import org.mule.runtime.extension.api.client.source.SourceHandler;
import org.mule.runtime.extension.api.client.source.SourceParameterizer;
import org.mule.runtime.extension.api.client.source.SourceResultHandler;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.internal.client.ComplexParameter;
import org.mule.runtime.extension.privileged.util.ComponentDeclarationUtils;
import org.mule.runtime.module.extension.api.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.api.runtime.resolver.ValueResolvingContext;
import org.mule.runtime.module.extension.internal.runtime.client.ShutdownExecutor;
import org.mule.runtime.module.extension.internal.runtime.client.operation.DefaultOperationParameterizer;
import org.mule.runtime.module.extension.internal.runtime.client.operation.EventedOperationsParameterDecorator;
import org.mule.runtime.module.extension.internal.runtime.client.operation.OperationClient;
import org.mule.runtime.module.extension.internal.runtime.client.operation.OperationKey;
import org.mule.runtime.module.extension.internal.runtime.client.source.DefaultSourceHandler;
import org.mule.runtime.module.extension.internal.runtime.client.source.SourceClient;
import org.mule.runtime.module.extension.internal.runtime.connectivity.ExtensionConnectionSupplier;
import org.mule.runtime.module.extension.internal.runtime.objectbuilder.DefaultObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.resolver.StaticValueResolver;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;
import org.mule.runtime.tracer.api.component.ComponentTracerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultExtensionsClient
implements ExtensionsClient,
Initialisable,
Disposable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultExtensionsClient.class);
    @Inject
    private ExtensionManager extensionManager;
    @Inject
    private ErrorTypeRepository errorTypeRepository;
    @Inject
    private ErrorTypeLocator errorTypeLocator;
    @Inject
    private ExtensionConnectionSupplier extensionConnectionSupplier;
    @Inject
    private ReflectionCache reflectionCache;
    @Inject
    private ExpressionManager expressionManager;
    @Inject
    private StreamingManager streamingManager;
    @Inject
    private NotificationDispatcher notificationDispatcher;
    @Inject
    private ComponentTracerFactory<CoreEvent> componentTracerFactory;
    @Inject
    private FeatureFlaggingService featureFlaggingService;
    @Inject
    private MuleContext muleContext;
    @Inject
    private MuleConfiguration muleConfiguration;
    @Inject
    private ArtifactEncoding artifactEncoding;
    private ExecutorService cacheShutdownExecutor;
    private LoadingCache<OperationKey, OperationClient> operationClientCache;
    private final Set<SourceClient> sourceClients = new HashSet<SourceClient>();

    public <T, A> CompletableFuture<Result<T, A>> execute(String extensionName, String operationName, Consumer<OperationParameterizer> parameters) {
        ExtensionModel extensionModel = this.findExtension(extensionName);
        OperationModel operationModel = this.findOperationModel(extensionModel, operationName);
        return this.doExecute(extensionModel, operationModel, parameters);
    }

    private <T, A> CompletableFuture<Result<T, A>> doExecute(ExtensionModel extensionModel, OperationModel operationModel, Consumer<OperationParameterizer> parameters) {
        DefaultOperationParameterizer parameterizer = new DefaultOperationParameterizer();
        parameters.accept(parameterizer);
        OperationKey key = new OperationKey(extensionModel, operationModel, parameterizer.getConfigRef());
        return ((OperationClient)this.operationClientCache.get((Object)key)).execute(key, parameterizer);
    }

    public <T, A> SourceHandler createSource(String extensionName, String sourceName, Consumer<SourceResultHandler<T, A>> handler, Consumer<SourceParameterizer> parameters) {
        ExtensionModel extensionModel = this.findExtension(extensionName);
        SourceModel sourceModel = this.findSourceModel(extensionModel, sourceName);
        SourceClient sourceClient = new SourceClient(extensionModel, sourceModel, parameters, handler, this.extensionManager, this.streamingManager, this.errorTypeLocator, this.reflectionCache, this.expressionManager, this.notificationDispatcher, this.muleContext);
        try {
            LifecycleUtils.initialiseIfNeeded(sourceClient, (boolean)true, (MuleContext)this.muleContext);
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Exception initializing source:" + e.getMessage())), (Throwable)e);
        }
        return new DefaultSourceHandler(sourceClient, () -> this.discard(sourceClient));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void discard(SourceClient sourceClient) {
        Set<SourceClient> set = this.sourceClients;
        synchronized (set) {
            try {
                this.stopAndDispose(sourceClient);
            }
            finally {
                this.sourceClients.remove(sourceClient);
            }
        }
    }

    private void stopAndDispose(SourceClient sourceClient) {
        try {
            sourceClient.stop();
        }
        catch (Exception e) {
            LOGGER.error("Exception found stopping source client: " + e.getMessage(), (Throwable)e);
        }
        finally {
            sourceClient.dispose();
        }
    }

    private LoadingCache<OperationKey, OperationClient> createOperationClientCache() {
        return Caffeine.newBuilder().executor((Executor)this.cacheShutdownExecutor).expireAfterAccess(5L, TimeUnit.MINUTES).removalListener((key, client, cause) -> this.disposeClient((OperationKey)key, (OperationClient)client)).build(this::createOperationClient);
    }

    private OperationClient createOperationClient(OperationKey key) {
        OperationClient client = OperationClient.from(key, this.extensionManager, this.expressionManager, this.extensionConnectionSupplier, this.errorTypeRepository, this.streamingManager, this.reflectionCache, this.componentTracerFactory, this.muleContext, this.muleConfiguration, this.artifactEncoding, this.notificationDispatcher);
        try {
            LifecycleUtils.initialiseIfNeeded((Object)client);
            LifecycleUtils.startIfNeeded((Object)client);
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Exception found creating operation client: " + e.getMessage())), (Throwable)e);
        }
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disposeClient(OperationKey identifier, OperationClient client) {
        try {
            LifecycleUtils.stopIfNeeded((Object)client);
        }
        catch (Exception e) {
            LOGGER.error("Exception found trying to stop operation client for operation {}", (Object)identifier);
        }
        finally {
            LifecycleUtils.disposeIfNeeded((Object)client, (Logger)LOGGER);
        }
    }

    private OperationModel findOperationModel(ExtensionModel extensionModel, String operationName) {
        return MuleExtensionUtils.findOperation(extensionModel, operationName).orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("No Operation [%s] Found", operationName))));
    }

    private SourceModel findSourceModel(ExtensionModel extensionModel, String sourceName) {
        return MuleExtensionUtils.findSource(extensionModel, sourceName).orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("No Source [%s] Found", sourceName))));
    }

    private ExtensionModel findExtension(String extensionName) {
        return (ExtensionModel)this.extensionManager.getExtension(extensionName).orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("No Extension [" + extensionName + "] Found"))));
    }

    @Deprecated
    public <T, A> CompletableFuture<Result<T, A>> executeAsync(String extensionName, String operationName, OperationParameters parameters) {
        if (this.featureFlaggingService.isEnabled((Feature)MuleRuntimeFeature.UNSUPPORTED_EXTENSIONS_CLIENT_RUN_ASYNC)) {
            throw new UnsupportedOperationException("executeAsync not supported. Ref MuleRuntimeFeature#UNSUPPORTED_EXTENSIONS_CLIENT_RUN_ASYNC");
        }
        ExtensionModel extensionModel = this.findExtension(extensionName);
        OperationModel operationModel = this.findOperationModel(extensionModel, operationName);
        return this.doExecute(extensionModel, operationModel, parameterizer -> {
            this.setContextEvent((OperationParameterizer)parameterizer, parameters);
            parameters.getConfigName().ifPresent(arg_0 -> ((OperationParameterizer)parameterizer).withConfigRef(arg_0));
            this.resolveLegacyParameters((OperationParameterizer)parameterizer, parameters);
            this.configureLegacyRepeatableStreaming((OperationParameterizer)parameterizer, operationModel);
        });
    }

    private void resolveLegacyParameters(OperationParameterizer parameterizer, OperationParameters legacyParameters) {
        this.resolveLegacyParameters(legacyParameters.get(), (arg_0, arg_1) -> ((OperationParameterizer)parameterizer).withParameter(arg_0, arg_1));
    }

    private void resolveLegacyParameters(Map<String, Object> parameters, BiConsumer<String, Object> resolvedValueConsumer) {
        parameters.forEach((paramName, value) -> {
            if ("config-ref".equals(paramName)) {
                return;
            }
            if (value instanceof ComplexParameter) {
                ComplexParameter complex = (ComplexParameter)value;
                DefaultObjectBuilder builder = new DefaultObjectBuilder(complex.getType(), this.reflectionCache);
                this.resolveLegacyParameters(complex.getParameters(), (String propertyName, Object propertyValue) -> builder.addPropertyResolver((String)propertyName, (ValueResolver<Object>)new StaticValueResolver<Object>(propertyValue)));
                value = FunctionalUtils.withNullEvent(event -> {
                    ValueResolvingContext ctx = ValueResolvingContext.builder(event).build();
                    try {
                        Object t = builder.build(ctx);
                        if (ctx != null) {
                            ctx.close();
                        }
                        return t;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (ctx != null) {
                                try {
                                    ctx.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (MuleException e) {
                            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Could not construct parameter [%s]", paramName)), (Throwable)e);
                        }
                    }
                });
            }
            resolvedValueConsumer.accept((String)paramName, value);
        });
    }

    @Deprecated
    public <T, A> Result<T, A> execute(String extension, String operation, OperationParameters params) throws MuleException {
        try {
            return this.executeAsync(extension, operation, params).get();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof MuleException) {
                MuleException muleException = (MuleException)cause;
                throw muleException;
            }
            throw new DefaultMuleException(cause);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new DefaultMuleException((Throwable)e);
        }
    }

    private void configureLegacyRepeatableStreaming(OperationParameterizer parameterizer, OperationModel operationModel) {
        if (ComponentDeclarationUtils.isPagedOperation((ComponentModel)operationModel)) {
            this.setDefaultRepeatableIterables(parameterizer);
        } else if (operationModel.supportsStreaming()) {
            this.setDefaultRepeatableStreaming(parameterizer);
        }
    }

    private void setDefaultRepeatableStreaming(OperationParameterizer parameterizer) {
        parameterizer.withDefaultRepeatableStreaming();
    }

    private void setDefaultRepeatableIterables(OperationParameterizer parameterizer) {
        parameterizer.withDefaultRepeatableIterables();
    }

    private void setContextEvent(OperationParameterizer parameterizer, OperationParameters parameters) {
        if (parameters instanceof EventedOperationsParameterDecorator) {
            EventedOperationsParameterDecorator eop = (EventedOperationsParameterDecorator)parameters;
            parameterizer.inTheContextOf(eop.getContextEvent());
        }
    }

    public void initialise() throws InitialisationException {
        this.cacheShutdownExecutor = new ShutdownExecutor();
        this.operationClientCache = this.createOperationClientCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Set<SourceClient> set = this.sourceClients;
        synchronized (set) {
            this.sourceClients.forEach(this::stopAndDispose);
            this.sourceClients.clear();
        }
        if (this.operationClientCache != null) {
            this.operationClientCache.invalidateAll();
        }
        if (this.cacheShutdownExecutor != null) {
            this.cacheShutdownExecutor.shutdown();
            MoreExecutors.shutdownAndAwaitTermination((ExecutorService)this.cacheShutdownExecutor, (long)5L, (TimeUnit)TimeUnit.SECONDS);
        }
    }
}

