/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util.store;

import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.store.ObjectStoreException;
import org.mule.runtime.api.store.ObjectStoreManager;
import org.mule.runtime.api.store.ObjectStoreSettings;
import org.mule.runtime.api.store.PartitionableExpirableObjectStore;
import org.mule.runtime.api.store.PartitionableObjectStore;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.internal.util.store.MonitoredObjectStoreWrapper;
import org.mule.runtime.core.internal.util.store.ObjectStorePartition;
import org.mule.runtime.core.internal.util.store.PartitionedObjectStoreWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuleObjectStoreManager
implements ObjectStoreManager,
Initialisable,
Disposable {
    private static Logger LOGGER = LoggerFactory.getLogger(MuleObjectStoreManager.class);
    public static final int UNBOUNDED = 0;
    private SchedulerService schedulerService;
    private Registry registry;
    private MuleContext muleContext;
    private final ConcurrentMap<String, ObjectStore<?>> stores = new ConcurrentHashMap();
    private final ConcurrentMap<String, Scheduler> expirationSchedulers = new ConcurrentHashMap<String, Scheduler>();
    private String baseTransientStoreKey = "_defaultInMemoryObjectStore";
    private String basePersistentStoreKey = "_defaultPersistentObjectStore";
    private ObjectStore<?> baseTransientStore;
    private ObjectStore<?> basePersistentStore;
    private ObjectStore<?> baseTransientPartition;
    private ObjectStore<?> basePersistentPartition;

    public void initialise() throws InitialisationException {
        this.basePersistentStore = this.lookupBaseStore(this.basePersistentStoreKey, "Persistent");
        this.baseTransientStore = this.lookupBaseStore(this.baseTransientStoreKey, "Transient");
        try {
            this.baseTransientPartition = this.getPartitionFromBaseObjectStore(this.baseTransientStore, this.baseTransientStoreKey);
            this.basePersistentPartition = this.getPartitionFromBaseObjectStore(this.basePersistentStore, this.basePersistentStoreKey);
        }
        catch (ObjectStoreException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    private ObjectStore<?> lookupBaseStore(String key, String baseType) throws InitialisationException {
        return (ObjectStore)this.registry.lookupByName(key).orElseThrow(() -> new InitialisationException(I18nMessageFactory.createStaticMessage((String)String.format("%s base store of key '%s' does not exists", baseType, key)), (Initialisable)this));
    }

    public void dispose() {
        for (Scheduler scheduler : this.expirationSchedulers.values()) {
            scheduler.stop();
        }
        this.expirationSchedulers.clear();
        this.basePersistentPartition = null;
        this.baseTransientPartition = null;
        this.basePersistentStore = null;
        this.baseTransientStore = null;
        this.stores.values().forEach(store -> LifecycleUtils.disposeIfNeeded(store, LOGGER));
        this.stores.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends ObjectStore<? extends Serializable>> T getObjectStore(String name) {
        ObjectStore store;
        if (this.basePersistentStoreKey.equals(name)) {
            return (T)this.basePersistentPartition;
        }
        if (this.baseTransientStoreKey.equals(name)) {
            return (T)this.baseTransientPartition;
        }
        ConcurrentMap<String, ObjectStore<?>> concurrentMap = this.stores;
        synchronized (concurrentMap) {
            store = (ObjectStore)this.stores.get(name);
        }
        if (store == null) {
            throw this.noSuchStoreException(name);
        }
        return (T)store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends ObjectStore<? extends Serializable>> T createObjectStore(String name, ObjectStoreSettings settings) {
        ConcurrentMap<String, ObjectStore<?>> concurrentMap = this.stores;
        synchronized (concurrentMap) {
            if (this.baseTransientStoreKey.equals(name) || this.basePersistentStoreKey.equals(name) || this.stores.containsKey(name)) {
                throw new IllegalArgumentException("An Object Store was already defined for name " + name);
            }
            T store = this.doCreateObjectStore(name, settings);
            this.stores.put(name, (ObjectStore<?>)store);
            return store;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends ObjectStore<? extends Serializable>> T getOrCreateObjectStore(String name, ObjectStoreSettings settings) {
        T objectStore;
        ConcurrentMap<String, ObjectStore<?>> concurrentMap = this.stores;
        synchronized (concurrentMap) {
            try {
                objectStore = this.getObjectStore(name);
            }
            catch (NoSuchElementException e) {
                objectStore = this.createObjectStore(name, settings);
            }
        }
        return objectStore;
    }

    private <T extends ObjectStore<?>> T doCreateObjectStore(String name, ObjectStoreSettings settings) {
        T store;
        T baseStore = this.getBaseStore(settings);
        try {
            store = this.getPartitionFromBaseObjectStore((ObjectStore<? extends Serializable>)baseStore, name);
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Found exception trying to create Object Store of name " + name)), (Throwable)e);
        }
        if (settings.getExpirationInterval() > 0L && (settings.getMaxEntries().isPresent() || settings.getEntryTTL().isPresent())) {
            store = this.getMonitorablePartition(name, (ObjectStore)baseStore, store, settings);
        }
        return store;
    }

    private <T extends ObjectStore<? extends Serializable>> T getBaseStore(ObjectStoreSettings settings) {
        return (T)(settings.isPersistent() ? this.basePersistentStore : this.baseTransientStore);
    }

    private <T extends ObjectStore<? extends Serializable>> T getPartitionFromBaseObjectStore(ObjectStore<? extends Serializable> baseStore, String partitionName) throws ObjectStoreException {
        if (baseStore instanceof PartitionableObjectStore) {
            ObjectStorePartition objectStorePartition = new ObjectStorePartition(partitionName, (PartitionableObjectStore)baseStore);
            objectStorePartition.open();
            return (T)((Object)objectStorePartition);
        }
        PartitionedObjectStoreWrapper<? extends Serializable> partitionedObjectStoreWrapper = new PartitionedObjectStoreWrapper<Serializable>(partitionName, baseStore);
        partitionedObjectStoreWrapper.open();
        return (T)((Object)partitionedObjectStoreWrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends ObjectStore<? extends Serializable>> T getMonitorablePartition(String name, ObjectStore baseStore, T store, ObjectStoreSettings settings) {
        MonitoredObjectStoreWrapper monObjectStore;
        if (baseStore instanceof PartitionableExpirableObjectStore) {
            Scheduler scheduler = this.schedulerService.customScheduler(this.muleContext.getSchedulerBaseConfig().withName("ObjectStoreManager-Monitor-" + name).withMaxConcurrentTasks(1));
            scheduler.scheduleWithFixedDelay((Runnable)new Monitor(name, (PartitionableExpirableObjectStore<? extends Serializable>)((PartitionableExpirableObjectStore)baseStore), settings.getEntryTTL().orElse(0L), settings.getMaxEntries().orElse(0)), 0L, settings.getExpirationInterval(), TimeUnit.MILLISECONDS);
            this.expirationSchedulers.put(name, scheduler);
            return store;
        }
        MuleObjectStoreManager muleObjectStoreManager = this;
        synchronized (muleObjectStoreManager) {
            monObjectStore = new MonitoredObjectStoreWrapper(store, settings);
            monObjectStore.setMuleContext(this.muleContext);
            try {
                monObjectStore.initialise();
            }
            catch (InitialisationException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        }
        return (T)monObjectStore;
    }

    public void clearStoreCache() {
        this.stores.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposeStore(String name) throws ObjectStoreException {
        if (this.basePersistentStoreKey.equals(name) || this.baseTransientStoreKey.equals(name)) {
            return;
        }
        ObjectStore store = (ObjectStore)this.stores.remove(name);
        if (store == null) {
            throw this.noSuchStoreException(name);
        }
        try {
            if (store instanceof ObjectStorePartition) {
                ObjectStorePartition partition = (ObjectStorePartition)store;
                String partitionName = partition.getPartitionName();
                partition.getBaseStore().disposePartition(partitionName);
                Scheduler scheduler = (Scheduler)this.expirationSchedulers.remove(partitionName);
                if (scheduler != null) {
                    scheduler.stop();
                }
            } else {
                try {
                    store.clear();
                }
                catch (UnsupportedOperationException e) {
                    LOGGER.warn(String.format("ObjectStore of class %s does not support clearing", store.getClass().getCanonicalName()), (Throwable)e);
                }
            }
        }
        finally {
            LifecycleUtils.disposeIfNeeded(store, LOGGER);
        }
    }

    private NoSuchElementException noSuchStoreException(String name) {
        return new NoSuchElementException("ObjectStore '" + name + "' is not defined");
    }

    int getMonitorsCount() {
        return this.expirationSchedulers.size();
    }

    public void setBasePersistentStoreKey(String basePersistentStoreKey) {
        this.basePersistentStoreKey = basePersistentStoreKey;
    }

    public void setBaseTransientStoreKey(String baseTransientStoreKey) {
        this.baseTransientStoreKey = baseTransientStoreKey;
    }

    @Inject
    public void setSchedulerService(SchedulerService schedulerService) {
        this.schedulerService = schedulerService;
    }

    @Inject
    public void setRegistry(Registry registry) {
        this.registry = registry;
    }

    @Inject
    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    class Monitor
    implements Runnable {
        private final String partitionName;
        private final PartitionableExpirableObjectStore<? extends Serializable> store;
        private final long entryTTL;
        private final int maxEntries;

        public Monitor(String partitionName, PartitionableExpirableObjectStore<? extends Serializable> store, long entryTTL, int maxEntries) {
            this.partitionName = partitionName;
            this.store = store;
            this.entryTTL = entryTTL;
            this.maxEntries = maxEntries;
        }

        @Override
        public void run() {
            if (MuleObjectStoreManager.this.muleContext.isPrimaryPollingInstance()) {
                try {
                    this.store.expire(this.entryTTL, this.maxEntries, this.partitionName);
                }
                catch (Exception e) {
                    LOGGER.warn("Running expirty on partition " + this.partitionName + " of " + this.store + " threw " + e + ":" + e.getMessage());
                }
            }
        }
    }
}

