/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util;

import java.util.Collections;
import java.util.List;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.util.ExceptionUtils;
import org.mule.runtime.core.internal.exception.ErrorMapping;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.message.ErrorBuilder;
import org.mule.runtime.core.privileged.exception.ErrorTypeLocator;

public final class InternalExceptionUtils {
    private InternalExceptionUtils() {
    }

    public static CoreEvent createErrorEvent(CoreEvent currentEvent, Component obj, MessagingException me, ErrorTypeLocator locator) {
        Object cause = me.getCause() != null ? me.getCause() : me;
        List<ErrorMapping> errorMappings = InternalExceptionUtils.getErrorMappings(obj);
        if (!errorMappings.isEmpty() || InternalExceptionUtils.isMessagingExceptionCause(me, (Throwable)cause)) {
            Error newError = InternalExceptionUtils.getErrorFromFailingProcessor(currentEvent, obj, (Throwable)cause, locator);
            CoreEvent newEvent = CoreEvent.builder(me.getEvent()).error(newError).build();
            me.setProcessedEvent(newEvent);
            return newEvent;
        }
        return currentEvent;
    }

    private static boolean isMessagingExceptionCause(MessagingException me, Throwable cause) {
        return !me.getEvent().getError().filter(error -> cause.equals(error.getCause())).filter(error -> me.causedExactlyBy(error.getCause().getClass())).isPresent();
    }

    public static List<ErrorMapping> getErrorMappings(Component object) {
        List<ErrorMapping> list = (List<ErrorMapping>)object.getAnnotation(ErrorMapping.ANNOTATION_ERROR_MAPPINGS);
        return list != null ? list : Collections.emptyList();
    }

    public static Error getErrorFromFailingProcessor(CoreEvent currentEvent, Component processor, Throwable cause, ErrorTypeLocator locator) {
        ErrorType currentError = currentEvent != null ? (ErrorType)currentEvent.getError().map(Error::getErrorType).orElse(null) : null;
        ErrorType foundErrorType = locator.lookupErrorType(cause);
        ErrorType resultError = ExceptionUtils.isUnknownMuleError(foundErrorType) ? currentError : foundErrorType;
        ErrorType errorType = ExceptionUtils.getComponentIdentifier(processor).map(ci -> locator.lookupComponentErrorType((ComponentIdentifier)ci, cause)).orElse(locator.lookupErrorType(cause));
        return ErrorBuilder.builder(cause).errorType(InternalExceptionUtils.getErrorMappings(processor).stream().filter(m -> m.match(resultError == null || ExceptionUtils.isUnknownMuleError(resultError) ? errorType : currentError)).findFirst().map(ErrorMapping::getTarget).orElse(errorType)).build();
    }
}

