/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.transaction.xa;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.transaction.xa.Xid;
import org.mule.runtime.core.api.transaction.xa.ResourceManagerException;
import org.mule.runtime.core.internal.transaction.xa.AbstractResourceManager;
import org.mule.runtime.core.internal.transaction.xa.AbstractXaTransactionContext;

public abstract class AbstractXAResourceManager<T extends AbstractXaTransactionContext>
extends AbstractResourceManager {
    private Map<Xid, T> suspendedContexts = new ConcurrentHashMap<Xid, T>();
    private Map<Xid, T> activeContexts = new ConcurrentHashMap<Xid, T>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int prepareTransaction(T context) throws ResourceManagerException {
        this.assureReady();
        T t = context;
        synchronized (t) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Preparing transaction " + context);
            }
            ((AbstractXaTransactionContext)context).status = 7;
            int status = this.doPrepare(context);
            ((AbstractXaTransactionContext)context).status = 2;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Prepared transaction " + context);
            }
            return status;
        }
    }

    protected abstract int doPrepare(T var1) throws ResourceManagerException;

    T getTransactionalResource(Xid xid) {
        T context = this.getActiveTransactionalResource(xid);
        if (context != null) {
            return context;
        }
        return this.getSuspendedTransactionalResource(xid);
    }

    T getActiveTransactionalResource(Xid xid) {
        return (T)((AbstractXaTransactionContext)this.activeContexts.get(xid));
    }

    T getSuspendedTransactionalResource(Xid xid) {
        return (T)((AbstractXaTransactionContext)this.suspendedContexts.get(xid));
    }

    void addActiveTransactionalResource(Xid xid, T context) {
        this.activeContexts.put(xid, context);
    }

    void addSuspendedTransactionalResource(Xid xid, T context) {
        this.suspendedContexts.put(xid, context);
    }

    void removeActiveTransactionalResource(Xid xid) {
        this.activeContexts.remove(xid);
    }

    void removeSuspendedTransactionalResource(Xid xid) {
        this.suspendedContexts.remove(xid);
    }
}

