/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor.interceptor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.interception.ProcessorInterceptorFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.internal.interception.ProcessorInterceptorManager;

public class DefaultProcessorInterceptorManager
implements ProcessorInterceptorManager,
Initialisable {
    @Inject
    private MuleContext context;
    private List<ProcessorInterceptorFactory> interceptorFactories = new ArrayList<ProcessorInterceptorFactory>();
    private List<String> interceptorsOrder = new ArrayList<String>();

    @Override
    @Inject
    @Named(value="_muleProcessorInterceptorFactoryOrder")
    public void setInterceptorsOrder(Optional<ProcessorInterceptorFactory.ProcessorInterceptorOrder> packagesOrder) {
        this.interceptorsOrder = packagesOrder.map(order -> (List)order.get()).orElse(Collections.emptyList());
    }

    public void initialise() throws InitialisationException {
        this.interceptorFactories.forEach(interceptorFactory -> {
            try {
                this.context.getInjector().inject(interceptorFactory);
            }
            catch (MuleException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        });
    }

    @Override
    @Inject
    public void setInterceptorFactories(Optional<List<ProcessorInterceptorFactory>> interceptorFactories) {
        this.interceptorFactories = interceptorFactories.orElse(Collections.emptyList());
    }

    @Override
    public List<ProcessorInterceptorFactory> getInterceptorFactories() {
        ArrayList<ProcessorInterceptorFactory> sortedInterceptors = new ArrayList<ProcessorInterceptorFactory>(this.interceptorFactories);
        sortedInterceptors.sort((o1, o2) -> this.orderIndexOf((ProcessorInterceptorFactory)o1) - this.orderIndexOf((ProcessorInterceptorFactory)o2));
        return Collections.unmodifiableList(sortedInterceptors);
    }

    private int orderIndexOf(ProcessorInterceptorFactory factory) {
        int i = 0;
        for (String interceptorsOrderItem : this.interceptorsOrder) {
            if (factory.getClass().getName().startsWith(interceptorsOrderItem)) {
                return i;
            }
            ++i;
        }
        return Integer.MAX_VALUE;
    }
}

