/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.inject.Inject;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.notification.AsyncMessageNotification;
import org.mule.runtime.api.notification.EnrichedNotificationInfo;
import org.mule.runtime.api.notification.Notification;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.AbstractMessageProcessorOwner;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.internal.component.ComponentUtils;
import org.mule.runtime.core.internal.event.DefaultEventContext;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.processor.strategy.DirectProcessingStrategyFactory;
import org.mule.runtime.core.internal.util.rx.Operators;
import org.mule.runtime.core.privileged.event.DefaultMuleSession;
import org.mule.runtime.core.privileged.event.PrivilegedEvent;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.runtime.core.privileged.processor.Scope;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

public class AsyncDelegateMessageProcessor
extends AbstractMessageProcessorOwner
implements Scope,
Initialisable,
Startable,
Stoppable {
    @Inject
    private SchedulerService schedulerService;
    @Inject
    private ConfigurationComponentLocator componentLocator;
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private ProcessingStrategy processingStrategy;
    protected MessageProcessorChain delegate;
    private org.mule.runtime.api.scheduler.Scheduler scheduler;
    private Scheduler reactorScheduler;
    protected String name;

    public AsyncDelegateMessageProcessor(MessageProcessorChain delegate) {
        this.delegate = delegate;
    }

    public AsyncDelegateMessageProcessor(MessageProcessorChain delegate, String name) {
        this.delegate = delegate;
        this.name = name;
    }

    @Override
    public void initialise() throws InitialisationException {
        Object rootContainer = ComponentUtils.getFromAnnotatedObject(this.componentLocator, this).orElse(null);
        this.processingStrategy = rootContainer instanceof FlowConstruct ? ((FlowConstruct)rootContainer).getProcessingStrategy() : DirectProcessingStrategyFactory.DIRECT_PROCESSING_STRATEGY_INSTANCE;
        if (this.delegate == null) {
            throw new InitialisationException(CoreMessages.objectIsNull("delegate message processor"), (Initialisable)this);
        }
        super.initialise();
    }

    @Override
    public void start() throws MuleException {
        this.scheduler = this.schedulerService.ioScheduler(this.muleContext.getSchedulerBaseConfig().withName(this.name != null ? this.name : this.getLocation().getLocation()));
        this.reactorScheduler = Schedulers.fromExecutorService((ExecutorService)this.scheduler);
        super.start();
    }

    @Override
    public void stop() throws MuleException {
        super.stop();
        if (this.scheduler != null) {
            this.scheduler.stop();
            this.scheduler = null;
        }
        if (this.reactorScheduler != null) {
            this.reactorScheduler.dispose();
            this.reactorScheduler = null;
        }
    }

    @Override
    public CoreEvent process(CoreEvent event) throws MuleException {
        return MessageProcessors.processToApply(event, this);
    }

    @Override
    public Publisher<CoreEvent> apply(Publisher<CoreEvent> publisher) {
        return Flux.from(publisher).cast(PrivilegedEvent.class).doOnNext(request -> Flux.just((Object)request).map(event -> this.asyncEvent((PrivilegedEvent)request)).transform(innerPublisher -> Flux.from((Publisher)innerPublisher).doOnNext(this.fireAsyncScheduledNotification()).doOnNext(asyncRequest -> Flux.just((Object)asyncRequest).cast(CoreEvent.class).transform((Function)this.scheduleAsync(this.delegate)).doOnNext(event -> this.fireAsyncCompleteNotification((CoreEvent)event, null)).doOnError(MessagingException.class, e -> this.fireAsyncCompleteNotification(e.getEvent(), (MessagingException)((Object)((Object)((Object)((Object)e)))))).doOnError(throwable -> this.logger.warn("Error occurred during asynchronous processing at:" + this.getLocation().getLocation() + " . To handle this error include a <try> scope in the <async> scope.", throwable)).subscribe(event -> asyncRequest.getContext().success((CoreEvent)event), throwable -> asyncRequest.getContext().error((Throwable)throwable)))).subscribe(Operators.requestUnbounded())).cast(CoreEvent.class);
    }

    private ReactiveProcessor scheduleAsync(Processor delegate) {
        if (!this.processingStrategy.isSynchronous()) {
            return publisher -> Flux.from((Publisher)publisher).transform((Function)this.processingStrategy.onPipeline(delegate));
        }
        return publisher -> Flux.from((Publisher)publisher).transform((Function)delegate).subscribeOn(this.reactorScheduler);
    }

    private PrivilegedEvent asyncEvent(PrivilegedEvent event) {
        return PrivilegedEvent.builder(DefaultEventContext.child(event.getContext(), Optional.ofNullable(this.getLocation())), event).replyToHandler(null).session(new DefaultMuleSession(event.getSession())).build();
    }

    private Consumer<CoreEvent> fireAsyncScheduledNotification() {
        return event -> this.muleContext.getNotificationManager().fireNotification((Notification)new AsyncMessageNotification(EnrichedNotificationInfo.createInfo((Event)event, null, (Component)this), this.getLocation(), 1901));
    }

    private void fireAsyncCompleteNotification(CoreEvent event, MessagingException exception) {
        this.muleContext.getNotificationManager().fireNotification((Notification)new AsyncMessageNotification(EnrichedNotificationInfo.createInfo((Event)event, (Exception)((Object)exception), (Component)this), this.getLocation(), 1902));
    }

    @Override
    protected List<Processor> getOwnedMessageProcessors() {
        return Collections.singletonList(this.delegate);
    }
}

