/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.policy;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.notification.EnrichedNotificationInfo;
import org.mule.runtime.api.notification.Notification;
import org.mule.runtime.api.notification.PolicyNotification;
import org.mule.runtime.core.api.context.notification.ServerNotificationHandler;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.internal.exception.MessagingException;

public class PolicyNotificationHelper {
    private ServerNotificationHandler notificationHandler;
    private String policyId;
    private Component component;

    public PolicyNotificationHelper(ServerNotificationHandler notificationHandler, String policyId, Component component) {
        this.notificationHandler = notificationHandler;
        this.policyId = policyId;
        this.component = component;
    }

    public Consumer<? super CoreEvent> notification(int action) {
        return event -> this.fireNotification((CoreEvent)event, null, action);
    }

    public Consumer<? super MessagingException> errorNotification(int action) {
        return e -> this.fireNotification(e.getEvent(), (Exception)((Object)e), action);
    }

    public BiConsumer<CoreEvent, Throwable> successOrErrorNotification(int action) {
        return (e, t) -> {
            if (t != null && t instanceof MessagingException) {
                this.errorNotification(action).accept((MessagingException)((Object)((Object)t)));
            } else if (e != null) {
                this.notification(action).accept((CoreEvent)e);
            }
        };
    }

    public void fireNotification(CoreEvent event, Exception e, int action) {
        if (this.notificationHandler != null && event != null && this.notificationHandler.isNotificationEnabled(PolicyNotification.class)) {
            this.notificationHandler.fireNotification((Notification)this.createNotification(event, e, action));
        }
    }

    private PolicyNotification createNotification(CoreEvent event, Exception e, int action) {
        EnrichedNotificationInfo info = EnrichedNotificationInfo.createInfo((Event)event, (Exception)e, (Component)this.component);
        return new PolicyNotification(this.policyId, info, action, this.component.getLocation());
    }
}

