/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.management.stats;

import java.util.concurrent.atomic.AtomicLong;
import org.mule.runtime.core.api.management.stats.FlowConstructStatistics;

public abstract class AbstractFlowConstructStatistics
implements FlowConstructStatistics {
    private static final long serialVersionUID = 5337576392583767442L;
    protected final String flowConstructType;
    protected String name;
    protected boolean enabled = false;
    private long samplePeriod = 0L;
    protected final AtomicLong receivedEvents = new AtomicLong(0L);

    public AbstractFlowConstructStatistics(String flowConstructType, String name) {
        this.name = name;
        this.flowConstructType = flowConstructType;
    }

    @Override
    public synchronized void setEnabled(boolean b) {
        this.enabled = b;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public synchronized String getName() {
        return this.name;
    }

    public synchronized void setName(String name) {
        this.name = name;
    }

    @Override
    public synchronized void clear() {
        this.receivedEvents.set(0L);
        this.samplePeriod = System.currentTimeMillis();
    }

    @Override
    public void incReceivedEvents() {
        this.receivedEvents.addAndGet(1L);
    }

    @Override
    public long getTotalEventsReceived() {
        return this.receivedEvents.get();
    }

    public String getFlowConstructType() {
        return this.flowConstructType;
    }

    public long getSamplePeriod() {
        return System.currentTimeMillis() - this.samplePeriod;
    }
}

