/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.lifecycle;

import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.lifecycle.LifecycleException;
import org.mule.runtime.api.notification.NotificationDispatcher;
import org.mule.runtime.core.api.lifecycle.LifecycleCallback;
import org.mule.runtime.core.api.lifecycle.LifecycleObject;
import org.mule.runtime.core.internal.context.MuleContextWithRegistries;
import org.mule.runtime.core.internal.lifecycle.HasLifecycleInterceptor;
import org.mule.runtime.core.internal.lifecycle.LifecycleInterceptor;
import org.mule.runtime.core.internal.lifecycle.NullLifecycleInterceptor;
import org.mule.runtime.core.internal.lifecycle.RegistryLifecycleManager;
import org.mule.runtime.core.internal.lifecycle.phases.ContainerManagedLifecyclePhase;
import org.mule.runtime.core.internal.lifecycle.phases.LifecyclePhase;
import org.mule.runtime.core.internal.registry.Registry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistryLifecycleCallback<T>
implements LifecycleCallback<T>,
HasLifecycleInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(RegistryLifecycleCallback.class);
    protected final RegistryLifecycleManager registryLifecycleManager;
    private LifecycleInterceptor interceptor = new NullLifecycleInterceptor();

    public RegistryLifecycleCallback(RegistryLifecycleManager registryLifecycleManager) {
        this.registryLifecycleManager = registryLifecycleManager;
    }

    @Override
    public void onTransition(String phaseName, T object) throws MuleException {
        try {
            this.registryLifecycleManager.muleContext.withLifecycleLock(() -> this.doOnTransition(phaseName, object));
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof MuleException) {
                throw (MuleException)e.getCause();
            }
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    private void doOnTransition(String phaseName, T object) throws MuleException {
        LifecyclePhase phase = this.registryLifecycleManager.phases.get(phaseName);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Applying lifecycle phase: %s for registry: %s", phase, object.getClass().getSimpleName()));
        }
        if (phase instanceof ContainerManagedLifecyclePhase) {
            phase.applyLifecycle(object);
            return;
        }
        HashSet<Object> duplicates = new HashSet<Object>();
        NotificationDispatcher notificationFirer = ((MuleContextWithRegistries)this.registryLifecycleManager.muleContext).getRegistry().lookupObject(NotificationDispatcher.class);
        for (LifecycleObject lifecycleObject : phase.getOrderedLifecycleObjects()) {
            lifecycleObject.firePreNotification(notificationFirer);
            Collection<?> targetsObj = this.lookupObjectsForLifecycle(lifecycleObject);
            this.doApplyLifecycle(phase, duplicates, lifecycleObject, targetsObj);
            lifecycleObject.firePostNotification(notificationFirer);
        }
        this.interceptor.onPhaseCompleted(phase);
    }

    private void doApplyLifecycle(LifecyclePhase phase, Set<Object> duplicates, LifecycleObject lifecycleObject, Collection<?> targetObjects) throws LifecycleException {
        if (CollectionUtils.isEmpty(targetObjects)) {
            return;
        }
        for (Object target : targetObjects) {
            if (duplicates.contains(target) || target == null) continue;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("lifecycle phase: " + phase.getName() + " for object: " + target);
            }
            this.applyLifecycle(phase, duplicates, target);
        }
        int originalTargetCount = targetObjects.size();
        targetObjects = this.lookupObjectsForLifecycle(lifecycleObject);
        if (targetObjects.size() > originalTargetCount) {
            this.doApplyLifecycle(phase, duplicates, lifecycleObject, targetObjects);
        }
    }

    private void applyLifecycle(LifecyclePhase phase, Set<Object> duplicates, Object target) throws LifecycleException {
        try {
            if (this.interceptor.beforePhaseExecution(phase, target)) {
                phase.applyLifecycle(target);
                duplicates.add(target);
                this.interceptor.afterPhaseExecution(phase, target, Optional.empty());
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("Skipping the application of the '%s' lifecycle phase over a certain object because a %s interceptor of type [%s] indicated so. Object is: %s", phase.getName(), LifecycleInterceptor.class.getSimpleName(), this.interceptor.getClass().getName(), target));
            }
        }
        catch (Exception e) {
            this.interceptor.afterPhaseExecution(phase, target, Optional.of(e));
            if (phase.getName().equals("dispose") || phase.getName().equals("stop")) {
                LOGGER.info(String.format("Failure executing phase %s over object %s, error message is: %s", phase.getName(), target, e.getMessage()), (Object)e.getMessage());
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(e.getMessage(), (Throwable)e);
                }
            }
            throw e;
        }
    }

    protected Collection<?> lookupObjectsForLifecycle(LifecycleObject lo) {
        return ((Registry)this.registryLifecycleManager.getLifecycleObject()).lookupObjectsForLifecycle(lo.getType());
    }

    @Override
    public void setLifecycleInterceptor(LifecycleInterceptor interceptor) {
        this.interceptor = interceptor;
    }
}

