/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.execution;

import java.util.concurrent.atomic.AtomicReference;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.scheduler.SchedulerBusyException;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.execution.TransactionalExecutionTemplate;
import org.mule.runtime.core.api.source.MessageSource;
import org.mule.runtime.core.api.transaction.MuleTransactionConfig;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.execution.MessageProcessPhase;
import org.mule.runtime.core.internal.execution.NotificationFiringProcessingPhase;
import org.mule.runtime.core.internal.execution.PhaseResultNotifier;
import org.mule.runtime.core.internal.execution.ValidationPhase;
import org.mule.runtime.core.privileged.exception.ResponseDispatchException;
import org.mule.runtime.core.privileged.execution.FlowProcessingPhaseTemplate;
import org.mule.runtime.core.privileged.execution.MessageProcessContext;
import org.mule.runtime.core.privileged.execution.MessageProcessTemplate;
import org.mule.runtime.core.privileged.execution.RequestResponseFlowProcessingPhaseTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowProcessingPhase
extends NotificationFiringProcessingPhase<FlowProcessingPhaseTemplate> {
    protected transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private Registry registry;

    public FlowProcessingPhase(Registry registry) {
        this.registry = registry;
    }

    @Override
    public boolean supportsTemplate(MessageProcessTemplate messageProcessTemplate) {
        return messageProcessTemplate instanceof FlowProcessingPhaseTemplate;
    }

    @Override
    public void runPhase(FlowProcessingPhaseTemplate flowProcessingPhaseTemplate, MessageProcessContext messageProcessContext, PhaseResultNotifier phaseResultNotifier) {
        Runnable flowExecutionWork = () -> {
            try {
                FlowConstruct flowConstruct = (FlowConstruct)this.registry.lookupByName(messageProcessContext.getMessageSource().getRootContainerLocation().toString()).get();
                try {
                    AtomicReference exceptionThrownDuringFlowProcessing = new AtomicReference();
                    TransactionalExecutionTemplate<CoreEvent> transactionTemplate = TransactionalExecutionTemplate.createTransactionalExecutionTemplate(this.muleContext, messageProcessContext.getTransactionConfig().orElse(new MuleTransactionConfig()));
                    CoreEvent response = transactionTemplate.execute(() -> {
                        try {
                            Object message = flowProcessingPhaseTemplate.getOriginalMessage();
                            if (message == null) {
                                return null;
                            }
                            CoreEvent muleEvent = flowProcessingPhaseTemplate.getEvent();
                            muleEvent = flowProcessingPhaseTemplate.beforeRouteEvent(muleEvent);
                            muleEvent = flowProcessingPhaseTemplate.routeEvent(muleEvent);
                            muleEvent = flowProcessingPhaseTemplate.afterRouteEvent(muleEvent);
                            this.sendResponseIfNeccessary(messageProcessContext.getMessageSource(), flowConstruct, muleEvent, flowProcessingPhaseTemplate);
                            return muleEvent;
                        }
                        catch (Exception e) {
                            exceptionThrownDuringFlowProcessing.set(e);
                            throw e;
                        }
                    });
                    if (exceptionThrownDuringFlowProcessing.get() != null && !(exceptionThrownDuringFlowProcessing.get() instanceof ResponseDispatchException)) {
                        this.sendResponseIfNeccessary(messageProcessContext.getMessageSource(), flowConstruct, response, flowProcessingPhaseTemplate);
                    }
                    flowProcessingPhaseTemplate.afterSuccessfulProcessingFlow(response);
                }
                catch (ResponseDispatchException e) {
                    flowProcessingPhaseTemplate.afterFailureProcessingFlow(e);
                }
                catch (MessagingException e) {
                    this.sendFailureResponseIfNeccessary(messageProcessContext.getMessageSource(), flowConstruct, e, flowProcessingPhaseTemplate);
                    flowProcessingPhaseTemplate.afterFailureProcessingFlow(e);
                }
                phaseResultNotifier.phaseSuccessfully();
            }
            catch (Exception e) {
                block8: {
                    DefaultMuleException me = new DefaultMuleException((Throwable)e);
                    try {
                        flowProcessingPhaseTemplate.afterFailureProcessingFlow((MuleException)me);
                    }
                    catch (MuleException e1) {
                        this.logger.warn("Failure during exception processing in flow template: " + e.getMessage());
                        if (!this.logger.isDebugEnabled()) break block8;
                        this.logger.debug("Failure during exception processing in flow template: ", (Throwable)e);
                    }
                }
                phaseResultNotifier.phaseFailure(e);
            }
        };
        if (messageProcessContext.supportsAsynchronousProcessing()) {
            try {
                messageProcessContext.getFlowExecutionExecutor().execute(flowExecutionWork);
            }
            catch (SchedulerBusyException e) {
                phaseResultNotifier.phaseFailure((Exception)((Object)e));
            }
        } else {
            flowExecutionWork.run();
        }
    }

    private void sendFailureResponseIfNeccessary(MessageSource messageSource, FlowConstruct flow, MessagingException messagingException, FlowProcessingPhaseTemplate flowProcessingPhaseTemplate) throws MuleException {
        if (flowProcessingPhaseTemplate instanceof RequestResponseFlowProcessingPhaseTemplate) {
            this.fireNotification(messageSource, messagingException.getEvent(), flow, 806);
            ((RequestResponseFlowProcessingPhaseTemplate)flowProcessingPhaseTemplate).sendFailureResponseToClient(messagingException);
        }
    }

    private void sendResponseIfNeccessary(MessageSource messageSource, FlowConstruct flow, CoreEvent muleEvent, FlowProcessingPhaseTemplate flowProcessingPhaseTemplate) throws MuleException {
        if (flowProcessingPhaseTemplate instanceof RequestResponseFlowProcessingPhaseTemplate) {
            this.fireNotification(messageSource, muleEvent, flow, 805);
            ((RequestResponseFlowProcessingPhaseTemplate)flowProcessingPhaseTemplate).sendResponseToClient(muleEvent);
        }
    }

    @Override
    public int compareTo(MessageProcessPhase messageProcessPhase) {
        if (messageProcessPhase instanceof ValidationPhase) {
            return 1;
        }
        return 0;
    }

    public void setRegistry(Registry registry) {
        this.registry = registry;
    }
}

