/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.exception;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.internal.config.ExceptionHelper;
import org.mule.runtime.core.privileged.exception.EventProcessingException;

public class MessagingException
extends EventProcessingException {
    public static final String PAYLOAD_INFO_KEY = "Payload";
    public static final String PAYLOAD_TYPE_INFO_KEY = "Payload Type";
    private static final long serialVersionUID = 6941498759267936649L;
    protected transient Message muleMessage;
    protected transient CoreEvent processedEvent;
    private boolean handled;
    private boolean inErrorHandler;
    private transient Component failingComponent;

    public MessagingException(I18nMessage message, CoreEvent event) {
        super(message, event);
        this.extractMuleMessage(event);
        this.storeErrorTypeInfo();
        this.setMessage(this.generateMessage(message, null));
    }

    public MessagingException(I18nMessage message, CoreEvent event, Component failingComponent) {
        super(message, event);
        this.extractMuleMessage(event);
        this.failingComponent = failingComponent;
        this.storeErrorTypeInfo();
        this.setMessage(this.generateMessage(message, null));
    }

    public MessagingException(I18nMessage message, CoreEvent event, Throwable cause) {
        super(message, event, cause);
        this.extractMuleMessage(event);
        this.storeErrorTypeInfo();
        this.setMessage(this.generateMessage(message, null));
    }

    public MessagingException(I18nMessage message, CoreEvent event, Throwable cause, Component failingComponent) {
        super(message, event, cause);
        this.extractMuleMessage(event);
        this.failingComponent = failingComponent;
        this.storeErrorTypeInfo();
        this.setMessage(this.generateMessage(message, null));
    }

    public MessagingException(CoreEvent event, Throwable cause) {
        super(event, cause);
        this.extractMuleMessage(event);
        this.storeErrorTypeInfo();
        this.setMessage(this.generateMessage(this.getI18nMessage(), null));
    }

    public MessagingException(CoreEvent event, MessagingException original) {
        super(original.getI18nMessage(), event, original.getCause());
        this.failingComponent = original.getFailingComponent();
        this.handled = original.handled();
        original.getInfo().forEach((key, value) -> this.addInfo((String)key, value));
        this.extractMuleMessage(event);
        this.storeErrorTypeInfo();
        this.setMessage(original.getMessage());
    }

    public MessagingException(CoreEvent event, Throwable cause, Component failingComponent) {
        super(event, cause);
        this.extractMuleMessage(event);
        this.failingComponent = failingComponent;
        this.storeErrorTypeInfo();
        this.setMessage(this.generateMessage(this.getI18nMessage(), null));
    }

    private void storeErrorTypeInfo() {
        if (this.event != null) {
            this.addInfo("Error type", this.getEvent().getError().map(e -> e.getErrorType().toString()).orElse("(None)"));
        }
    }

    protected String generateMessage(I18nMessage message, MuleContext muleContext) {
        StringBuilder buf = new StringBuilder(80);
        if (message != null) {
            buf.append(message.getMessage());
            String trimmedMessage = message.getMessage().trim();
            if (StringUtils.isNotBlank((CharSequence)trimmedMessage) && trimmedMessage.charAt(trimmedMessage.length() - 1) != '.') {
                buf.append(".");
            }
        }
        if (this.muleMessage != null) {
            if (MuleException.isVerboseExceptions()) {
                Object payload = this.muleMessage.getPayload().getValue();
                if (this.muleMessage.getPayload().getDataType().isStreamType()) {
                    this.addInfo(PAYLOAD_INFO_KEY, StringUtils.abbreviate((String)payload.toString(), (int)1000));
                } else if (payload != null) {
                    this.addInfo(PAYLOAD_TYPE_INFO_KEY, this.muleMessage.getPayload().getDataType().getType().getName());
                    if (muleContext != null) {
                        try {
                            this.addInfo(PAYLOAD_INFO_KEY, muleContext.getTransformationService().transform(this.muleMessage, DataType.STRING).getPayload().getValue());
                        }
                        catch (Exception e) {
                            this.addInfo(PAYLOAD_INFO_KEY, String.format("%s while getting payload: %s", e.getClass().getName(), e.getMessage()));
                        }
                        this.addInfo(PAYLOAD_INFO_KEY, this.muleMessage.toString());
                    }
                } else {
                    this.addInfo(PAYLOAD_TYPE_INFO_KEY, Objects.toString(null));
                    this.addInfo(PAYLOAD_INFO_KEY, Objects.toString(null));
                }
            }
        } else {
            buf.append("The current Message is null!");
            this.addInfo(PAYLOAD_INFO_KEY, Objects.toString(null));
        }
        return buf.toString();
    }

    @Deprecated
    public Message getMuleMessage() {
        if (this.getEvent() != null) {
            return this.getEvent().getMessage();
        }
        return this.muleMessage;
    }

    @Override
    public CoreEvent getEvent() {
        return this.processedEvent != null ? this.processedEvent : this.event;
    }

    public void setProcessedEvent(CoreEvent processedEvent) {
        if (processedEvent != null) {
            this.processedEvent = processedEvent;
            this.extractMuleMessage(processedEvent);
        } else {
            this.processedEvent = null;
            this.muleMessage = null;
        }
    }

    public boolean causedBy(Class e) {
        if (e == null) {
            throw new IllegalArgumentException("Class cannot be null");
        }
        return ExceptionHelper.traverseCauseHierarchy((Throwable)((Object)this), causeException -> {
            if (e.isAssignableFrom(causeException.getClass())) {
                return causeException;
            }
            return null;
        }) != null;
    }

    public boolean causedExactlyBy(Class<? extends Throwable> e) {
        if (e == null) {
            throw new IllegalArgumentException("Class cannot be null");
        }
        return ExceptionHelper.traverseCauseHierarchy((Throwable)((Object)this), causeException -> {
            if (causeException.getClass().equals(e)) {
                return causeException;
            }
            return null;
        }) != null;
    }

    public Throwable getRootCause() {
        Object rootException = ExceptionHelper.getRootException((Throwable)((Object)this));
        if (rootException == null) {
            rootException = this;
        }
        return rootException;
    }

    public boolean causeMatches(String regex) {
        if (regex == null) {
            throw new IllegalArgumentException("regex cannot be null");
        }
        Boolean matched = ExceptionHelper.traverseCauseHierarchy((Throwable)((Object)this), e -> e.getClass().getName().matches(regex));
        return matched != null && matched != false;
    }

    public void setHandled(boolean handled) {
        this.handled = handled;
    }

    public boolean handled() {
        return this.handled;
    }

    public void setInErrorHandler(boolean inErrorHandler) {
        this.inErrorHandler = inErrorHandler;
    }

    public boolean inErrorHandler() {
        return this.inErrorHandler;
    }

    @Override
    public Component getFailingComponent() {
        return this.failingComponent;
    }

    protected void extractMuleMessage(CoreEvent event) {
        this.muleMessage = event == null ? null : event.getMessage();
    }

    private void writeObject(ObjectOutputStream out) throws Exception {
        out.defaultWriteObject();
        if (this.failingComponent instanceof Serializable) {
            out.writeBoolean(true);
            out.writeObject(this.failingComponent);
        } else {
            out.writeBoolean(false);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        boolean failingComponentWasSerialized = in.readBoolean();
        if (failingComponentWasSerialized) {
            this.failingComponent = (Component)in.readObject();
        }
    }

    public String toString() {
        return super.toString() + "; ErrorType: " + this.getEvent().getError().map(e -> e.getErrorType().toString()).orElse("(None)");
    }
}

