/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.connection;

import java.util.concurrent.atomic.AtomicBoolean;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.internal.connection.ConnectionHandlerAdapter;

final class PassThroughConnectionHandler<C>
implements ConnectionHandlerAdapter<C> {
    private final C connection;
    private final ConnectionProvider<C> connectionProvider;
    private final AtomicBoolean released = new AtomicBoolean(false);

    PassThroughConnectionHandler(C connection, ConnectionProvider<C> connectionProvider) {
        this.connection = connection;
        this.connectionProvider = connectionProvider;
    }

    public C getConnection() throws ConnectionException {
        return this.connection;
    }

    @Override
    public void close() throws MuleException {
        this.release();
    }

    public void release() {
        if (this.released.compareAndSet(false, true)) {
            this.connectionProvider.disconnect(this.connection);
        }
    }

    @Override
    public ConnectionProvider<C> getConnectionProvider() {
        return this.connectionProvider;
    }

    public void invalidate() {
        this.release();
    }
}

