/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.connection;

import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.internal.connection.ConnectionHandlerAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Exceptions;

final class CachedConnectionHandler<C>
implements ConnectionHandlerAdapter<C> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CachedConnectionHandler.class);
    private final ConnectionProvider<C> connectionProvider;
    private final MuleContext muleContext;
    private LazyValue<C> connection;

    public CachedConnectionHandler(ConnectionProvider<C> connectionProvider, MuleContext muleContext) {
        this.connectionProvider = connectionProvider;
        this.muleContext = muleContext;
        this.lazyConnect();
    }

    public C getConnection() throws ConnectionException {
        try {
            return (C)this.connection.get();
        }
        catch (Throwable t) {
            t = Exceptions.unwrap((Throwable)t);
            if (t instanceof ConnectionException) {
                throw (ConnectionException)t;
            }
            throw new ConnectionException(t.getMessage(), t);
        }
    }

    private C createConnection() throws ConnectionException {
        LifecycleUtils.assertNotStopping(this.muleContext, "Mule is shutting down... Cannot establish new connections");
        return (C)this.connectionProvider.connect();
    }

    public void release() {
    }

    @Override
    public void close() throws MuleException {
        this.disconnectAndCleanConnection();
    }

    public void invalidate() {
        this.disconnectAndCleanConnection();
        this.lazyConnect();
    }

    @Override
    public ConnectionProvider<C> getConnectionProvider() {
        return this.connectionProvider;
    }

    private void disconnectAndCleanConnection() {
        this.connection.ifComputed(c -> {
            try {
                this.connectionProvider.disconnect(c);
            }
            catch (Exception e) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(String.format("Error disconnecting cached connection %s. %s", c, e.getMessage()), (Throwable)e);
                }
            }
            finally {
                this.connection = null;
            }
        });
    }

    private void lazyConnect() {
        this.connection = new LazyValue(this::createConnection);
    }
}

