/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.source.scheduler;

import java.util.TimeZone;
import java.util.concurrent.ScheduledFuture;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.source.CronSchedulerConfiguration;
import org.mule.runtime.core.api.source.scheduler.PeriodicScheduler;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alias(value="cron")
public final class CronScheduler
extends PeriodicScheduler
implements CronSchedulerConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(CronScheduler.class);
    private static final String TZ_GMT_ID = "GMT";
    @Parameter
    private String expression;
    @Parameter
    private String timeZone;

    @Override
    protected ScheduledFuture<?> doSchedule(Scheduler executor, Runnable job) {
        return executor.scheduleWithCronExpression(job, this.expression, this.resolveTimeZone(this.timeZone));
    }

    protected TimeZone resolveTimeZone(String name) {
        TimeZone resolvedTimeZone;
        TimeZone timeZone = resolvedTimeZone = this.timeZone == null ? TimeZone.getDefault() : TimeZone.getTimeZone(this.timeZone);
        if (!TZ_GMT_ID.equals(this.timeZone) && resolvedTimeZone.equals(TimeZone.getTimeZone(TZ_GMT_ID))) {
            logger.warn(String.format("Configured timezone '%s' is invalid in scheduler '%s'. Defaulting to %s", this.timeZone, name, TZ_GMT_ID));
        }
        return resolvedTimeZone;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public String getExpression() {
        return this.expression;
    }

    public String getTimeZone() {
        return this.timeZone;
    }
}

