/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.security;

import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.core.api.security.EncryptionStrategy;

public final class CryptoFailureException
extends MuleException {
    private static final long serialVersionUID = 1336343718508294379L;
    private transient EncryptionStrategy encryptionStrategy;

    public CryptoFailureException(I18nMessage message, EncryptionStrategy strategy) {
        super(message);
        String s = strategy == null ? "null" : strategy.toString();
        this.addInfo("Encryption", s);
        this.encryptionStrategy = strategy;
    }

    public CryptoFailureException(I18nMessage message, EncryptionStrategy strategy, Throwable cause) {
        super(message, cause);
        String s = strategy == null ? "null" : strategy.toString();
        this.addInfo("Encryption", s);
        this.encryptionStrategy = strategy;
    }

    public CryptoFailureException(EncryptionStrategy strategy, Throwable cause) {
        super(I18nMessageFactory.createStaticMessage((String)"Crypto Failure"), cause);
        String s = strategy == null ? "null" : strategy.toString();
        this.addInfo("Encryption", s);
        this.encryptionStrategy = strategy;
    }

    public EncryptionStrategy getEncryptionStrategy() {
        return this.encryptionStrategy;
    }
}

