/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.retry.async;

import java.util.Map;
import java.util.concurrent.Executor;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.util.concurrent.Latch;
import org.mule.runtime.core.api.retry.RetryCallback;
import org.mule.runtime.core.api.retry.RetryContext;
import org.mule.runtime.core.api.retry.RetryNotifier;
import org.mule.runtime.core.api.retry.policy.RetryPolicy;
import org.mule.runtime.core.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.core.internal.retry.async.FutureRetryContext;
import org.mule.runtime.core.internal.retry.async.RetryWorker;

public final class AsynchronousRetryTemplate
extends AbstractComponent
implements RetryPolicyTemplate {
    private final RetryPolicyTemplate delegate;
    private Latch startLatch;

    public AsynchronousRetryTemplate(RetryPolicyTemplate delegate) {
        this.delegate = delegate;
    }

    @Override
    public RetryContext execute(RetryCallback callback, Executor workManager) throws Exception {
        if (workManager == null) {
            throw new IllegalStateException("Cannot schedule a work till the workManager is initialized. Probably the connector hasn't been initialized yet");
        }
        RetryWorker worker = new RetryWorker(this.delegate, callback, workManager, this.startLatch);
        FutureRetryContext context = worker.getRetryContext();
        workManager.execute(worker);
        return context;
    }

    @Override
    public RetryPolicy createRetryInstance() {
        return this.delegate.createRetryInstance();
    }

    @Override
    public RetryNotifier getNotifier() {
        return this.delegate.getNotifier();
    }

    @Override
    public void setNotifier(RetryNotifier retryNotifier) {
        this.delegate.setNotifier(retryNotifier);
    }

    @Override
    public Map<Object, Object> getMetaInfo() {
        return this.delegate.getMetaInfo();
    }

    @Override
    public void setMetaInfo(Map<Object, Object> metaInfo) {
        this.delegate.setMetaInfo(metaInfo);
    }

    public RetryPolicyTemplate getDelegate() {
        return this.delegate;
    }

    public void setStartLatch(Latch latch) {
        this.startLatch = latch;
    }
}

