/*
 * Decompiled with CFR 0.152.
 */
package org.mule.mvel2.conversion;

import org.mule.mvel2.ConversionHandler;
import org.mule.mvel2.Unit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnitConversion
implements ConversionHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnitConversion.class);

    public Object convertFrom(Object in) {
        try {
            return ((Unit)Unit.class.newInstance()).convertFrom(in);
        }
        catch (InstantiationException e) {
            LOGGER.error("Could not instantiate unit", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOGGER.error("Could not access unit", (Throwable)e);
        }
        return null;
    }

    public boolean canConvertFrom(Class cls) {
        if (Unit.class.isAssignableFrom(cls) || Number.class.isAssignableFrom(cls)) {
            try {
                return ((Unit)Unit.class.newInstance()).canConvertFrom(cls);
            }
            catch (InstantiationException e) {
                LOGGER.error("Could not instantiate unit", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                LOGGER.error("Could not access unit", (Throwable)e);
            }
        }
        return false;
    }
}

