/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.journal.queue;

import com.google.common.collect.Multimap;
import java.io.Serializable;
import java.util.Collection;
import org.apache.commons.collections.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleRuntimeException;
import org.mule.util.CollectionUtils;
import org.mule.util.journal.queue.LocalQueueTxJournalEntry;
import org.mule.util.journal.queue.LocalTxQueueTransactionJournal;
import org.mule.util.queue.QueueProvider;
import org.mule.util.queue.RecoverableQueueStore;

public class LocalTxQueueTransactionRecoverer {
    private Log logger = LogFactory.getLog(this.getClass());
    private final LocalTxQueueTransactionJournal localTxQueueTransactionJournal;
    private final QueueProvider queueProvider;

    public LocalTxQueueTransactionRecoverer(LocalTxQueueTransactionJournal localTxQueueTransactionJournal, QueueProvider queueProvider) {
        this.localTxQueueTransactionJournal = localTxQueueTransactionJournal;
        this.queueProvider = queueProvider;
    }

    public void recover() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Executing transaction recovery");
        }
        Multimap allEntries = this.localTxQueueTransactionJournal.getAllLogEntries();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Found " + allEntries.size() + " txs to recover"));
        }
        int txRecovered = 0;
        for (Integer txId : allEntries.keySet()) {
            Collection entries = allEntries.get((Object)txId);
            Object commitOrRollback = CollectionUtils.find((Collection)entries, (Predicate)new Predicate(){

                public boolean evaluate(Object object) {
                    LocalQueueTxJournalEntry logEntry = (LocalQueueTxJournalEntry)object;
                    return logEntry.isCommit() || logEntry.isRollback();
                }
            });
            if (commitOrRollback != null) continue;
            ++txRecovered;
            for (LocalQueueTxJournalEntry logEntry : entries) {
                if (logEntry.isRemove()) {
                    Serializable polledValue;
                    String queueName = logEntry.getQueueName();
                    RecoverableQueueStore queue = this.queueProvider.getRecoveryQueue(queueName);
                    if (queue.contains(polledValue = logEntry.getValue())) continue;
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("re-adding polled element that was not commited to queue " + queue.getName()));
                    }
                    try {
                        queue.putNow(polledValue);
                        continue;
                    }
                    catch (InterruptedException e) {
                        throw new MuleRuntimeException(e);
                    }
                }
                if (!logEntry.isAdd() && !logEntry.isAddFirst()) continue;
                Serializable offeredValue = logEntry.getValue();
                String queueName = logEntry.getQueueName();
                RecoverableQueueStore queue = this.queueProvider.getRecoveryQueue(queueName);
                if (!queue.contains(offeredValue)) continue;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("removing offer element that was not commited to queue " + queue.getName()));
                }
                queue.remove(offeredValue);
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Recovered " + txRecovered + " txs to recover"));
        }
        this.localTxQueueTransactionJournal.clear();
    }
}

