/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport;

import org.mule.api.context.WorkManager;
import org.mule.transport.AbstractPollingMessageReceiver;
import org.mule.transport.PollingReceiverWorker;

public class PollingReceiverWorkerSchedule
implements Runnable {
    protected final PollingReceiverWorker worker;
    protected final WorkManager workManager;
    protected final AbstractPollingMessageReceiver receiver;
    private final ClassLoader classLoader;

    protected PollingReceiverWorkerSchedule(PollingReceiverWorker work) {
        this.worker = work;
        this.receiver = work.getReceiver();
        this.workManager = this.receiver.getWorkManager();
        this.classLoader = Thread.currentThread().getContextClassLoader();
    }

    @Override
    public void run() {
        ClassLoader originalCl = Thread.currentThread().getContextClassLoader();
        try {
            try {
                Thread.currentThread().setContextClassLoader(this.classLoader);
                if (!this.worker.isRunning()) {
                    this.workManager.scheduleWork(this.worker);
                }
            }
            catch (Exception e) {
                this.receiver.getEndpoint().getMuleContext().getExceptionListener().handleException(e);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalCl);
        }
    }
}

