/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import org.mule.VoidMuleEvent;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.construct.FlowConstructAware;
import org.mule.api.context.MuleContextAware;
import org.mule.api.execution.LocationExecutionContextProvider;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Lifecycle;
import org.mule.api.lifecycle.LifecycleUtils;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.filter.Filter;
import org.mule.api.routing.filter.FilterUnacceptedException;
import org.mule.config.i18n.CoreMessages;
import org.mule.processor.AbstractFilteringMessageProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageFilter
extends AbstractFilteringMessageProcessor
implements FlowConstructAware,
Lifecycle {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageFilter.class);
    protected Filter filter;

    @Deprecated
    public MessageFilter() {
    }

    public MessageFilter(Filter filter) {
        this.filter = filter;
    }

    public MessageFilter(Filter filter, boolean throwExceptionOnUnaccepted, MessageProcessor messageProcessor) {
        this.filter = filter;
        this.throwOnUnaccepted = throwExceptionOnUnaccepted;
        this.unacceptedMessageProcessor = messageProcessor;
        this.setUnacceptedMessageProcessor(this.unacceptedMessageProcessor);
    }

    @Override
    protected boolean accept(MuleEvent event) {
        if (this.filter == null) {
            return true;
        }
        if (event != null && !VoidMuleEvent.getInstance().equals(event)) {
            return this.filter.accept(event.getMessage());
        }
        return false;
    }

    @Override
    protected MessagingException filterFailureException(MuleEvent event, Exception ex) {
        MessagingException messagingException = new MessagingException(event, ex, (MessageProcessor)this);
        String docName = LocationExecutionContextProvider.getDocName(this.filter);
        messagingException.getInfo().put("Filter", docName != null ? String.format("%s (%s)", this.filter.toString(), docName) : this.filter.toString());
        return messagingException;
    }

    @Override
    protected MuleException filterUnacceptedException(MuleEvent event) {
        return new FilterUnacceptedException(CoreMessages.messageRejectedByFilter(), event, this.filter, (MessageProcessor)this);
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    @Override
    public String toString() {
        return (this.filter == null ? "null filter" : this.filter.getClass().getName()) + " (wrapped by " + this.getClass().getSimpleName() + ")";
    }

    @Override
    public void setMuleContext(MuleContext context) {
        super.setMuleContext(context);
        if (!this.onUnacceptedFlowConstruct && this.unacceptedMessageProcessor instanceof MuleContextAware) {
            ((MuleContextAware)((Object)this.unacceptedMessageProcessor)).setMuleContext(context);
        }
    }

    @Override
    public void setFlowConstruct(FlowConstruct flowConstruct) {
        if (!this.onUnacceptedFlowConstruct && this.unacceptedMessageProcessor instanceof FlowConstructAware) {
            ((FlowConstructAware)((Object)this.unacceptedMessageProcessor)).setFlowConstruct(flowConstruct);
        }
    }

    @Override
    public void initialise() throws InitialisationException {
        if (!this.onUnacceptedFlowConstruct && this.unacceptedMessageProcessor instanceof Initialisable) {
            ((Initialisable)((Object)this.unacceptedMessageProcessor)).initialise();
        }
        LifecycleUtils.initialiseIfNeeded(this.filter);
    }

    @Override
    public void start() throws MuleException {
        if (!this.onUnacceptedFlowConstruct && this.unacceptedMessageProcessor instanceof Startable) {
            ((Startable)((Object)this.unacceptedMessageProcessor)).start();
        }
    }

    @Override
    public void stop() throws MuleException {
        if (!this.onUnacceptedFlowConstruct && this.unacceptedMessageProcessor instanceof Stoppable) {
            ((Stoppable)((Object)this.unacceptedMessageProcessor)).stop();
        }
    }

    @Override
    public void dispose() {
        if (!this.onUnacceptedFlowConstruct && this.unacceptedMessageProcessor instanceof Disposable) {
            ((Disposable)((Object)this.unacceptedMessageProcessor)).dispose();
        }
        LifecycleUtils.disposeIfNeeded(this.filter, LOGGER);
    }
}

