/*
 * Decompiled with CFR 0.152.
 */
package org.mule.message;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleEvent;
import org.mule.api.transport.PropertyScope;

public class ExceptionMessage
implements Serializable {
    private static final long serialVersionUID = -538516243574950621L;
    private static final Log logger = LogFactory.getLog(ExceptionMessage.class);
    private transient Object payload;
    private transient Throwable exception;
    protected Map<String, Object> properties;
    private String componentName;
    private String endpointUri;
    private Date timeStamp;

    public ExceptionMessage(MuleEvent event, Throwable exception, String componentName, URI endpointUri) {
        this.payload = event.getMessage().getPayload();
        this.properties = new HashMap<String, Object>();
        this.exception = exception;
        this.timeStamp = new Date();
        this.componentName = componentName;
        if (endpointUri != null) {
            this.endpointUri = endpointUri.toString();
        }
        for (String propertyKey : event.getMessage().getPropertyNames(PropertyScope.OUTBOUND)) {
            this.setProperty(propertyKey, event.getMessage().getProperty(propertyKey, PropertyScope.OUTBOUND));
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        try {
            out.writeObject(this.exception);
        }
        catch (NotSerializableException e) {
            logger.warn((Object)("Exception " + this.exception.getClass().getName() + " is not serializable and will be lost when sending ExceptionMessage over the wire: " + e.getMessage()));
        }
        try {
            out.writeObject(this.payload);
        }
        catch (NotSerializableException e) {
            logger.warn((Object)("Payload " + this.payload.getClass().getName() + " is not serializable and will be lost when sending ExceptionMessage over the wire: " + e.getMessage()));
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        try {
            this.exception = (Throwable)in.readObject();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.payload = in.readObject();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setPayload(Object payload) {
        this.payload = payload;
    }

    public Object getPayload() {
        return this.payload;
    }

    public void addProperties(Map<String, Object> properties) {
        this.properties.putAll(properties);
    }

    public void clearProperties() {
        this.properties.clear();
    }

    public Map getProperties() {
        return this.properties;
    }

    public void setProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    public String getComponentName() {
        return this.componentName;
    }

    public String getEndpoint() {
        return this.endpointUri;
    }

    public Date getTimeStamp() {
        return this.timeStamp;
    }

    public Throwable getException() {
        return this.exception;
    }

    public String toString() {
        return "ExceptionMessage{payload=" + this.getPayload() + ", context=" + this.properties + "exception=" + this.exception + ", componentName='" + this.componentName + "', endpointUri=" + this.endpointUri + ", timeStamp=" + this.timeStamp + "}";
    }
}

