/*
 * Decompiled with CFR 0.152.
 */
package org.mule.endpoint.outbound;

import org.mule.OptimizedRequestContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.util.ObjectUtils;

public class OutboundEndpointPropertyMessageProcessor
implements MessageProcessor {
    private String[] ignoredPropertyOverrides = new String[]{"method"};
    private OutboundEndpoint endpoint;

    public OutboundEndpointPropertyMessageProcessor(OutboundEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    @Override
    public MuleEvent process(MuleEvent event) throws MuleException {
        event.getMessage().setOutboundProperty("MULE_ENDPOINT", this.endpoint.getEndpointURI().toString());
        if (this.endpoint.getProperties() != null) {
            for (String prop : this.endpoint.getProperties().keySet()) {
                Object value = this.endpoint.getProperties().get(prop);
                if (this.ignoreProperty(event.getMessage(), prop)) continue;
                event.getMessage().setInvocationProperty(prop, value);
            }
        }
        event = OptimizedRequestContext.unsafeSetEvent(event);
        return event;
    }

    protected boolean ignoreProperty(MuleMessage message, String key) {
        if (key == null) {
            return true;
        }
        for (int i = 0; i < this.ignoredPropertyOverrides.length; ++i) {
            if (!key.equals(this.ignoredPropertyOverrides[i])) continue;
            return false;
        }
        return null != message.getOutboundProperty(key);
    }

    public String toString() {
        return ObjectUtils.toString(this);
    }
}

