/*
 * Decompiled with CFR 0.152.
 */
package org.mule.endpoint;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.EndpointException;
import org.mule.api.endpoint.EndpointMessageProcessorChainFactory;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.exception.MessagingExceptionHandler;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.retry.RetryPolicyTemplate;
import org.mule.api.routing.filter.Filter;
import org.mule.api.security.EndpointSecurityFilter;
import org.mule.api.transaction.TransactionConfig;
import org.mule.api.transformer.Transformer;
import org.mule.api.transport.Connector;
import org.mule.api.transport.DispatchException;
import org.mule.endpoint.AbstractEndpointBuilder;
import org.mule.endpoint.DynamicURIBuilder;
import org.mule.endpoint.MuleEndpointURI;
import org.mule.endpoint.URIBuilder;
import org.mule.processor.AbstractRedeliveryPolicy;
import org.mule.transport.AbstractConnector;
import org.mule.util.ObjectNameHelper;

public class DynamicOutboundEndpoint
implements OutboundEndpoint {
    protected final transient Log logger = LogFactory.getLog(DynamicOutboundEndpoint.class);
    private static final long serialVersionUID = 8861985949279708638L;
    private final EndpointBuilder endpointBuilder;
    private final OutboundEndpoint prototypeEndpoint;
    private final Map<String, OutboundEndpoint> staticEndpoints = Collections.synchronizedMap(new LRUMap(64));
    private final DynamicURIBuilder dynamicURIBuilder;
    private MessagingExceptionHandler exceptionHandler;

    public DynamicOutboundEndpoint(EndpointBuilder endpointBuilder, DynamicURIBuilder dynamicURIBuilder) {
        this.endpointBuilder = endpointBuilder;
        this.dynamicURIBuilder = dynamicURIBuilder;
        try {
            this.prototypeEndpoint = endpointBuilder.buildOutboundEndpoint();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Properties getServiceOverrides() throws EndpointException {
        Connector connector;
        Properties properties = null;
        if (this.endpointBuilder instanceof AbstractEndpointBuilder && (connector = ((AbstractEndpointBuilder)this.endpointBuilder).getConnector()) instanceof AbstractConnector && ((AbstractConnector)connector).getServiceOverrides() != null) {
            properties = new Properties();
            properties.putAll((Map<?, ?>)((AbstractConnector)connector).getServiceOverrides());
        }
        return properties;
    }

    public OutboundEndpoint getStaticEndpoint(MuleEvent event) throws MuleException {
        String uri = this.resolveUri(event);
        OutboundEndpoint outboundEndpoint = this.staticEndpoints.get(uri);
        if (outboundEndpoint == null) {
            EndpointURI endpointURIForMessage = this.createEndpointUri(uri);
            outboundEndpoint = this.createStaticEndpoint(endpointURIForMessage);
            this.staticEndpoints.put(uri, outboundEndpoint);
        }
        return outboundEndpoint;
    }

    private EndpointURI createEndpointUri(String uri) throws EndpointException, InitialisationException {
        MuleEndpointURI endpointUri = new MuleEndpointURI(uri, this.getMuleContext(), this.getServiceOverrides());
        endpointUri.initialise();
        return endpointUri;
    }

    private String resolveUri(MuleEvent event) throws DispatchException {
        try {
            return this.dynamicURIBuilder.build(event);
        }
        catch (Exception e) {
            throw new DispatchException(event, this, (Throwable)e);
        }
    }

    private OutboundEndpoint createStaticEndpoint(EndpointURI uri) throws EndpointException, InitialisationException {
        try {
            EndpointBuilder staticBuilder = (EndpointBuilder)this.endpointBuilder.clone();
            staticBuilder.setURIBuilder(new URIBuilder(uri));
            String endpointName = ObjectNameHelper.getEndpointNameFor(uri);
            staticBuilder.setName(endpointName);
            OutboundEndpoint endpoint = staticBuilder.buildOutboundEndpoint();
            endpoint.setMessagingExceptionHandler(this.exceptionHandler);
            return endpoint;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Unable to clone endpoint builder");
        }
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public Connector getConnector() {
        throw new UnsupportedOperationException("No connector available");
    }

    @Override
    public EndpointURI getEndpointURI() {
        return null;
    }

    @Override
    public AbstractRedeliveryPolicy getRedeliveryPolicy() {
        return this.prototypeEndpoint.getRedeliveryPolicy();
    }

    @Override
    public String getAddress() {
        return this.dynamicURIBuilder.getUriTemplate();
    }

    @Override
    public RetryPolicyTemplate getRetryPolicyTemplate() {
        return this.prototypeEndpoint.getRetryPolicyTemplate();
    }

    @Override
    public String getEncoding() {
        return this.prototypeEndpoint.getEncoding();
    }

    @Override
    public String getMimeType() {
        return this.prototypeEndpoint.getMimeType();
    }

    @Override
    public Filter getFilter() {
        return this.prototypeEndpoint.getFilter();
    }

    @Override
    public String getInitialState() {
        return this.prototypeEndpoint.getInitialState();
    }

    @Override
    public MuleContext getMuleContext() {
        return this.prototypeEndpoint.getMuleContext();
    }

    @Override
    public String getName() {
        return this.prototypeEndpoint.getName();
    }

    @Override
    public Map getProperties() {
        return this.prototypeEndpoint.getProperties();
    }

    @Override
    public Object getProperty(Object key) {
        return this.prototypeEndpoint.getProperty(key);
    }

    @Override
    public String getProtocol() {
        return this.prototypeEndpoint.getProtocol();
    }

    @Override
    public int getResponseTimeout() {
        return this.prototypeEndpoint.getResponseTimeout();
    }

    @Override
    public List<Transformer> getResponseTransformers() {
        return this.prototypeEndpoint.getResponseTransformers();
    }

    @Override
    public EndpointMessageProcessorChainFactory getMessageProcessorsFactory() {
        return this.prototypeEndpoint.getMessageProcessorsFactory();
    }

    @Override
    public List<MessageProcessor> getMessageProcessors() {
        return this.prototypeEndpoint.getMessageProcessors();
    }

    @Override
    public List<MessageProcessor> getResponseMessageProcessors() {
        return this.prototypeEndpoint.getResponseMessageProcessors();
    }

    @Override
    public EndpointSecurityFilter getSecurityFilter() {
        return this.prototypeEndpoint.getSecurityFilter();
    }

    @Override
    public TransactionConfig getTransactionConfig() {
        return this.prototypeEndpoint.getTransactionConfig();
    }

    @Override
    public List<Transformer> getTransformers() {
        return this.prototypeEndpoint.getTransformers();
    }

    @Override
    public boolean isDeleteUnacceptedMessages() {
        return this.prototypeEndpoint.isDeleteUnacceptedMessages();
    }

    @Override
    public boolean isReadOnly() {
        return this.prototypeEndpoint.isReadOnly();
    }

    @Override
    public MessageExchangePattern getExchangePattern() {
        return this.prototypeEndpoint.getExchangePattern();
    }

    @Override
    public List<String> getResponseProperties() {
        return this.prototypeEndpoint.getResponseProperties();
    }

    @Override
    public boolean isDynamic() {
        return true;
    }

    @Override
    public String getEndpointBuilderName() {
        return this.prototypeEndpoint.getEndpointBuilderName();
    }

    @Override
    public boolean isProtocolSupported(String protocol) {
        return this.prototypeEndpoint.isProtocolSupported(protocol);
    }

    @Override
    public boolean isDisableTransportTransformer() {
        return this.prototypeEndpoint.isDisableTransportTransformer();
    }

    @Override
    public MuleEvent process(MuleEvent event) throws MuleException {
        return this.getStaticEndpoint(event).process(event);
    }

    @Override
    public void setMessagingExceptionHandler(MessagingExceptionHandler messagingExceptionHandler) {
        this.exceptionHandler = messagingExceptionHandler;
    }
}

