/*
 * Decompiled with CFR 0.152.
 */
package org.mule.context;

import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.config.ConfigurationBuilder;
import org.mule.api.config.ConfigurationException;
import org.mule.api.config.MuleConfiguration;
import org.mule.api.context.MuleContextBuilder;
import org.mule.api.context.MuleContextFactory;
import org.mule.api.context.notification.MuleContextListener;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.config.DefaultMuleConfiguration;
import org.mule.config.builders.AutoConfigurationBuilder;
import org.mule.config.builders.DefaultsConfigurationBuilder;
import org.mule.config.builders.SimpleConfigurationBuilder;
import org.mule.context.DefaultMuleContextBuilder;

public class DefaultMuleContextFactory
implements MuleContextFactory {
    protected static final Log logger = LogFactory.getLog(DefaultMuleContextBuilder.class);
    private List<MuleContextListener> listeners = new LinkedList<MuleContextListener>();

    @Override
    public MuleContext createMuleContext() throws InitialisationException, ConfigurationException {
        return this.createMuleContext((ConfigurationBuilder)new DefaultsConfigurationBuilder(), (MuleContextBuilder)this.createMuleContextBuilder());
    }

    protected DefaultMuleContextBuilder createMuleContextBuilder() {
        return new DefaultMuleContextBuilder();
    }

    @Override
    public MuleContext createMuleContext(ConfigurationBuilder configurationBuilder) throws InitialisationException, ConfigurationException {
        return this.createMuleContext(configurationBuilder, (MuleContextBuilder)this.createMuleContextBuilder());
    }

    @Override
    public MuleContext createMuleContext(MuleContextBuilder muleContextBuilder) throws InitialisationException, ConfigurationException {
        return this.createMuleContext((ConfigurationBuilder)new DefaultsConfigurationBuilder(), muleContextBuilder);
    }

    @Override
    public MuleContext createMuleContext(final List<ConfigurationBuilder> configurationBuilders, MuleContextBuilder muleContextBuilder) throws InitialisationException, ConfigurationException {
        return this.doCreateMuleContext(muleContextBuilder, new ContextConfigurator(){

            @Override
            public void configure(MuleContext muleContext) throws ConfigurationException, InitialisationException {
                for (ConfigurationBuilder configBuilder : configurationBuilders) {
                    configBuilder.configure(muleContext);
                }
                DefaultMuleContextFactory.this.notifyMuleContextConfiguration(muleContext);
            }
        });
    }

    @Override
    public MuleContext createMuleContext(final ConfigurationBuilder configurationBuilder, MuleContextBuilder muleContextBuilder) throws InitialisationException, ConfigurationException {
        return this.doCreateMuleContext(muleContextBuilder, new ContextConfigurator(){

            @Override
            public void configure(MuleContext muleContext) throws ConfigurationException, InitialisationException {
                configurationBuilder.configure(muleContext);
                DefaultMuleContextFactory.this.notifyMuleContextConfiguration(muleContext);
            }
        });
    }

    public MuleContext createMuleContext(String resource) throws InitialisationException, ConfigurationException {
        return this.createMuleContext(resource, null);
    }

    public MuleContext createMuleContext(final String configResources, final Properties properties) throws InitialisationException, ConfigurationException {
        return this.doCreateMuleContext(this.createMuleContextBuilder(), new ContextConfigurator(){

            @Override
            public void configure(MuleContext muleContext) throws ConfigurationException, InitialisationException {
                if (properties != null && !properties.isEmpty()) {
                    new SimpleConfigurationBuilder(properties).configure(muleContext);
                }
                new AutoConfigurationBuilder(configResources).configure(muleContext);
                DefaultMuleContextFactory.this.notifyMuleContextConfiguration(muleContext);
            }
        });
    }

    public MuleContext createMuleContext(ConfigurationBuilder configurationBuilder, Properties properties) throws InitialisationException, ConfigurationException {
        return this.createMuleContext(configurationBuilder, properties, new DefaultMuleConfiguration());
    }

    public MuleContext createMuleContext(final ConfigurationBuilder configurationBuilder, final Properties properties, MuleConfiguration configuration) throws InitialisationException, ConfigurationException {
        DefaultMuleContextBuilder contextBuilder = this.createMuleContextBuilder();
        contextBuilder.setMuleConfiguration(configuration);
        return this.doCreateMuleContext(contextBuilder, new ContextConfigurator(){

            @Override
            public void configure(MuleContext muleContext) throws ConfigurationException, InitialisationException {
                if (properties != null && !properties.isEmpty()) {
                    new SimpleConfigurationBuilder(properties).configure(muleContext);
                }
                configurationBuilder.configure(muleContext);
                DefaultMuleContextFactory.this.notifyMuleContextConfiguration(muleContext);
            }
        });
    }

    protected MuleContext doCreateMuleContext(MuleContextBuilder muleContextBuilder, ContextConfigurator configurator) throws InitialisationException, ConfigurationException {
        MuleContext muleContext = this.buildMuleContext(muleContextBuilder);
        this.notifyMuleContextCreation(muleContext);
        muleContext.initialise();
        this.notifyMuleContextInitialization(muleContext);
        try {
            configurator.configure(muleContext);
        }
        catch (ConfigurationException e) {
            block5: {
                if (muleContext != null && !muleContext.isDisposed()) {
                    try {
                        muleContext.dispose();
                    }
                    catch (Exception e1) {
                        logger.warn((Object)("Can not dispose context. " + ExceptionUtils.getMessage((Throwable)e1)));
                        if (!logger.isDebugEnabled()) break block5;
                        logger.debug((Object)("Can not dispose context. " + ExceptionUtils.getStackTrace((Throwable)e1)));
                    }
                }
            }
            throw e;
        }
        return muleContext;
    }

    protected MuleContext buildMuleContext(MuleContextBuilder muleContextBuilder) {
        return muleContextBuilder.buildMuleContext();
    }

    @Override
    public void addListener(MuleContextListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public boolean removeListener(MuleContextListener listener) {
        return this.listeners.remove(listener);
    }

    private void notifyMuleContextCreation(MuleContext context) {
        for (MuleContextListener listener : this.listeners) {
            listener.onCreation(context);
        }
    }

    private void notifyMuleContextInitialization(MuleContext context) {
        for (MuleContextListener listener : this.listeners) {
            listener.onInitialization(context);
        }
    }

    private void notifyMuleContextConfiguration(MuleContext context) {
        for (MuleContextListener listener : this.listeners) {
            listener.onConfiguration(context);
        }
    }

    private abstract class ContextConfigurator {
        private ContextConfigurator() {
        }

        public abstract void configure(MuleContext var1) throws ConfigurationException, InitialisationException;
    }
}

