/*
 * Decompiled with CFR 0.152.
 */
package org.mule.construct.builder;

import java.util.Arrays;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.transaction.TransactionConfig;
import org.mule.api.transaction.TransactionException;
import org.mule.api.transaction.TransactionFactory;
import org.mule.api.transformer.Transformer;
import org.mule.config.i18n.MessageFactory;
import org.mule.construct.Bridge;
import org.mule.construct.builder.AbstractFlowConstructWithSingleInboundAndOutboundEndpointBuilder;
import org.mule.transaction.MuleTransactionConfig;
import org.mule.transaction.XaTransactionFactory;
import org.mule.util.ClassUtils;
import org.mule.util.StringUtils;

public class BridgeBuilder
extends AbstractFlowConstructWithSingleInboundAndOutboundEndpointBuilder<BridgeBuilder, Bridge> {
    protected MessageExchangePattern exchangePattern = MessageExchangePattern.REQUEST_RESPONSE;
    protected boolean transacted = false;

    @Override
    protected MessageExchangePattern getInboundMessageExchangePattern() {
        return this.exchangePattern;
    }

    @Override
    protected MessageExchangePattern getOutboundMessageExchangePattern() {
        return this.exchangePattern;
    }

    public BridgeBuilder exchangePattern(MessageExchangePattern exchangePattern) {
        this.exchangePattern = exchangePattern;
        return this;
    }

    public BridgeBuilder transacted(boolean transacted) {
        this.transacted = transacted;
        return this;
    }

    public BridgeBuilder transformers(Transformer ... transformers) {
        this.transformers = Arrays.asList((MessageProcessor[])transformers);
        return this;
    }

    public BridgeBuilder responseTransformers(Transformer ... responseTransformers) {
        this.responseTransformers = Arrays.asList((MessageProcessor[])responseTransformers);
        return this;
    }

    @Override
    protected void doConfigureInboundEndpointBuilder(MuleContext muleContext, EndpointBuilder endpointBuilder) {
        if (this.transacted) {
            MuleTransactionConfig transactionConfig = new MuleTransactionConfig(2);
            transactionConfig.setMuleContext(muleContext);
            endpointBuilder.setTransactionConfig(transactionConfig);
        }
    }

    @Override
    protected void doConfigureOutboundEndpointBuilder(MuleContext muleContext, EndpointBuilder endpointBuilder) {
        if (this.transacted) {
            MuleTransactionConfig transactionConfig = new MuleTransactionConfig(3);
            transactionConfig.setMuleContext(muleContext);
            endpointBuilder.setTransactionConfig(transactionConfig);
        }
    }

    @Override
    protected Bridge buildFlowConstruct(MuleContext muleContext) throws MuleException {
        InboundEndpoint inboundEndpoint = this.getOrBuildInboundEndpoint(muleContext);
        OutboundEndpoint outboundEndpoint = this.getOrBuildOutboundEndpoint(muleContext);
        if (this.transacted) {
            this.setTransactionFactoriesIfNeeded(inboundEndpoint, outboundEndpoint);
        }
        return new Bridge(this.name, muleContext, inboundEndpoint, outboundEndpoint, this.transformers, this.responseTransformers, this.exchangePattern, this.transacted);
    }

    private void setTransactionFactoriesIfNeeded(InboundEndpoint inboundEndpoint, OutboundEndpoint outboundEndpoint) throws MuleException {
        TransactionConfig outboundTransactionConfig;
        String outboundProtocol;
        String inboundProtocol = inboundEndpoint.getConnector().getProtocol();
        boolean needXA = !inboundProtocol.equals(outboundProtocol = outboundEndpoint.getConnector().getProtocol());
        TransactionConfig inboundTransactionConfig = inboundEndpoint.getTransactionConfig();
        if (inboundTransactionConfig.getFactory() == null) {
            TransactionFactory transactionFactory = needXA ? new XaTransactionFactory() : this.getTransactionFactory(inboundProtocol);
            inboundTransactionConfig.setFactory(transactionFactory);
        }
        if ((outboundTransactionConfig = outboundEndpoint.getTransactionConfig()).getFactory() == null) {
            TransactionFactory transactionFactory = needXA ? new XaTransactionFactory() : this.getTransactionFactory(outboundProtocol);
            outboundTransactionConfig.setFactory(transactionFactory);
        }
    }

    private TransactionFactory getTransactionFactory(String protocol) throws MuleException {
        String protocolTransactionFactoryClassName = "org.mule.transport." + StringUtils.lowerCase((String)protocol) + "." + StringUtils.capitalize((String)protocol) + "TransactionFactory";
        if (!ClassUtils.isClassOnPath(protocolTransactionFactoryClassName, this.getClass())) {
            throw new TransactionException(MessageFactory.createStaticMessage("Failed to locate a transaction factory for protocol: " + protocol));
        }
        try {
            return (TransactionFactory)ClassUtils.instanciateClass(protocolTransactionFactoryClassName, new Object[0]);
        }
        catch (Exception e) {
            throw new TransactionException(MessageFactory.createStaticMessage("Failed to instantiate a transaction factory for protocol: " + protocol), (Throwable)e);
        }
    }
}

