/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.bootstrap;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.bootstrap.BootstrapException;
import org.mule.config.bootstrap.RegistryBootstrapDiscoverer;
import org.mule.config.i18n.MessageFactory;
import org.mule.util.ClassUtils;
import org.mule.util.OrderedProperties;

public class ClassPathRegistryBootstrapDiscoverer
implements RegistryBootstrapDiscoverer {
    private static final String BOOTSTRAP_PROPERTIES = "META-INF/services/org/mule/config/registry-bootstrap.properties";
    private final transient Log logger = LogFactory.getLog(this.getClass());

    @Override
    public List<Properties> discover() throws BootstrapException {
        LinkedList<Properties> bootstrapsProperties = new LinkedList<Properties>();
        Enumeration<URL> allPropertiesResources = ClassUtils.getResources(BOOTSTRAP_PROPERTIES, this.getClass());
        while (allPropertiesResources.hasMoreElements()) {
            URL propertiesResource = allPropertiesResources.nextElement();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Reading bootstrap properties from: " + propertiesResource.toString()));
            }
            OrderedProperties properties = new OrderedProperties();
            try (InputStream resourceStream = propertiesResource.openStream();){
                properties.load(resourceStream);
            }
            catch (IOException e) {
                throw new BootstrapException(MessageFactory.createStaticMessage("Could not load properties from: %s", propertiesResource.toString()), (Throwable)e);
            }
            bootstrapsProperties.add(properties);
        }
        return bootstrapsProperties;
    }
}

