/*
 * Decompiled with CFR 0.152.
 */
package org.mule.api.processor;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.AbstractAnnotatedObject;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.context.MuleContextAware;
import org.mule.api.expression.ExpressionManager;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.util.StringUtils;

public class LoggerMessageProcessor
extends AbstractAnnotatedObject
implements MessageProcessor,
Initialisable,
MuleContextAware {
    protected transient Log logger;
    protected String message;
    protected String category;
    protected String level = "DEBUG";
    protected MuleContext muleContext;
    protected ExpressionManager expressionManager;

    @Override
    public void initialise() throws InitialisationException {
        this.initLogger();
        this.expressionManager = this.muleContext.getExpressionManager();
    }

    protected void initLogger() {
        this.logger = this.category != null ? LogFactory.getLog((String)this.category) : LogFactory.getLog(LoggerMessageProcessor.class);
    }

    @Override
    public MuleEvent process(MuleEvent event) throws MuleException {
        this.log(event);
        return event;
    }

    protected void log(MuleEvent event) {
        if (event == null) {
            this.logWithLevel(null);
        } else if (StringUtils.isEmpty((String)this.message)) {
            this.logWithLevel(event.getMessage());
        } else {
            LogLevel logLevel = LogLevel.valueOf(this.level);
            if (LogLevel.valueOf(this.level).isEnabled(this.logger)) {
                logLevel.log(this.logger, this.expressionManager.parse(this.message, event));
            }
        }
    }

    protected void logWithLevel(Object object) {
        LogLevel logLevel = LogLevel.valueOf(this.level);
        if (logLevel.isEnabled(this.logger)) {
            logLevel.log(this.logger, object);
        }
    }

    @Override
    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public void setLevel(String level) {
        this.level = level.toUpperCase();
    }

    public static enum LogLevel {
        ERROR{

            @Override
            public void log(Log logger, Object object) {
                logger.error(object);
            }

            @Override
            public boolean isEnabled(Log logger) {
                return logger.isErrorEnabled();
            }
        }
        ,
        WARN{

            @Override
            public void log(Log logger, Object object) {
                logger.warn(object);
            }

            @Override
            public boolean isEnabled(Log logger) {
                return logger.isWarnEnabled();
            }
        }
        ,
        INFO{

            @Override
            public void log(Log logger, Object object) {
                logger.info(object);
            }

            @Override
            public boolean isEnabled(Log logger) {
                return logger.isInfoEnabled();
            }
        }
        ,
        DEBUG{

            @Override
            public void log(Log logger, Object object) {
                logger.debug(object);
            }

            @Override
            public boolean isEnabled(Log logger) {
                return logger.isDebugEnabled();
            }
        }
        ,
        TRACE{

            @Override
            public void log(Log logger, Object object) {
                logger.trace(object);
            }

            @Override
            public boolean isEnabled(Log logger) {
                return logger.isTraceEnabled();
            }
        };


        public abstract void log(Log var1, Object var2);

        public abstract boolean isEnabled(Log var1);
    }
}

