/*
 * Decompiled with CFR 0.152.
 */
package org.mule.api.debug;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.api.MuleEvent;
import org.mule.api.debug.ErrorFieldDebugInfo;
import org.mule.api.debug.FieldDebugInfo;
import org.mule.api.debug.ObjectFieldDebugInfo;
import org.mule.api.debug.SimpleFieldDebugInfo;
import org.mule.util.AttributeEvaluator;

public class FieldDebugInfoFactory {
    private static final Map<Class, AttributeEvaluatorExecutor> attributeEvaluationExecutors = new HashMap<Class, AttributeEvaluatorExecutor>();
    private static final AttributeEvaluatorExecutor DEFAULT_ATTRIBUTE_EVALUATOR_EXECUTOR = new ObjectAttributeEvaluatorExecutor();

    private FieldDebugInfoFactory() {
    }

    public static FieldDebugInfo<?> createFieldDebugInfo(String name, Class<?> type, AttributeEvaluator evaluator, MuleEvent event) {
        try {
            AttributeEvaluatorExecutor attributeEvaluatorExecutor = attributeEvaluationExecutors.get(type);
            if (attributeEvaluatorExecutor == null) {
                attributeEvaluatorExecutor = DEFAULT_ATTRIBUTE_EVALUATOR_EXECUTOR;
            }
            Object value = attributeEvaluatorExecutor.evaluate(event, evaluator);
            return new SimpleFieldDebugInfo(name, FieldDebugInfoFactory.getTypeName(type), value);
        }
        catch (Exception e) {
            return new ErrorFieldDebugInfo(name, FieldDebugInfoFactory.getTypeName(type), e);
        }
    }

    public static FieldDebugInfo createFieldDebugInfo(String name, Class<?> type, FieldEvaluator evaluator) {
        try {
            return new SimpleFieldDebugInfo(name, FieldDebugInfoFactory.getTypeName(type), evaluator.evaluate());
        }
        catch (Exception e) {
            return new ErrorFieldDebugInfo(name, FieldDebugInfoFactory.getTypeName(type), e);
        }
    }

    public static SimpleFieldDebugInfo createFieldDebugInfo(String name, Class<?> type, Object value) {
        return FieldDebugInfoFactory.createFieldDebugInfo(name, FieldDebugInfoFactory.getTypeName(type), value);
    }

    public static ObjectFieldDebugInfo createFieldDebugInfo(String name, Class<?> type, List<FieldDebugInfo<?>> fields) {
        return FieldDebugInfoFactory.createFieldDebugInfo(name, FieldDebugInfoFactory.getTypeName(type), fields);
    }

    public static ErrorFieldDebugInfo createFieldDebugInfo(String name, Class<?> type, Exception value) {
        return FieldDebugInfoFactory.createFieldDebugInfo(name, FieldDebugInfoFactory.getTypeName(type), value);
    }

    public static SimpleFieldDebugInfo createFieldDebugInfo(String name, String type, Object value) {
        return new SimpleFieldDebugInfo(name, type, value);
    }

    public static ObjectFieldDebugInfo createFieldDebugInfo(String name, String type, List<FieldDebugInfo<?>> fields) {
        return new ObjectFieldDebugInfo(name, type, fields);
    }

    public static ErrorFieldDebugInfo createFieldDebugInfo(String name, String type, Exception value) {
        return new ErrorFieldDebugInfo(name, type, value);
    }

    private static String getTypeName(Class<?> type) {
        return type != null ? type.getName() : null;
    }

    static {
        attributeEvaluationExecutors.put(String.class, new StringAttributeEvaluatorExecutor());
        attributeEvaluationExecutors.put(Boolean.class, new BooleanAttributeEvaluatorExecutor());
        attributeEvaluationExecutors.put(Integer.class, new IntegerAttributeEvaluatorExecutor());
        attributeEvaluationExecutors.put(Object.class, DEFAULT_ATTRIBUTE_EVALUATOR_EXECUTOR);
    }

    public static interface FieldEvaluator {
        public Object evaluate() throws Exception;
    }

    private static class ObjectAttributeEvaluatorExecutor
    implements AttributeEvaluatorExecutor {
        private ObjectAttributeEvaluatorExecutor() {
        }

        @Override
        public Object evaluate(MuleEvent event, AttributeEvaluator attributeEvaluator) {
            return attributeEvaluator.resolveValue(event);
        }
    }

    private static class IntegerAttributeEvaluatorExecutor
    implements AttributeEvaluatorExecutor {
        private IntegerAttributeEvaluatorExecutor() {
        }

        @Override
        public Object evaluate(MuleEvent event, AttributeEvaluator attributeEvaluator) {
            return attributeEvaluator.resolveIntegerValue(event);
        }
    }

    private static class StringAttributeEvaluatorExecutor
    implements AttributeEvaluatorExecutor {
        private StringAttributeEvaluatorExecutor() {
        }

        @Override
        public Object evaluate(MuleEvent event, AttributeEvaluator attributeEvaluator) {
            return attributeEvaluator.resolveStringValue(event);
        }
    }

    private static class BooleanAttributeEvaluatorExecutor
    implements AttributeEvaluatorExecutor {
        private BooleanAttributeEvaluatorExecutor() {
        }

        @Override
        public Object evaluate(MuleEvent event, AttributeEvaluator attributeEvaluator) {
            return attributeEvaluator.resolveBooleanValue(event);
        }
    }

    private static interface AttributeEvaluatorExecutor {
        public Object evaluate(MuleEvent var1, AttributeEvaluator var2);
    }
}

