/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.processors;

import java.beans.PropertyDescriptor;
import org.mule.config.spring.OptionalObjectsController;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessor;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;

public class DiscardedOptionalBeanPostProcessor
implements InstantiationAwareBeanPostProcessor {
    private final OptionalObjectsController optionalObjectsController;
    private final DefaultListableBeanFactory beanFactory;

    public DiscardedOptionalBeanPostProcessor(OptionalObjectsController optionalObjectsController, DefaultListableBeanFactory beanFactory) {
        this.optionalObjectsController = optionalObjectsController;
        this.beanFactory = beanFactory;
    }

    public Object postProcessBeforeInstantiation(Class<?> beanClass, String beanName) throws BeansException {
        return null;
    }

    public boolean postProcessAfterInstantiation(Object bean, String beanName) throws BeansException {
        return !this.optionalObjectsController.isDiscarded(beanName);
    }

    public PropertyValues postProcessPropertyValues(PropertyValues pvs, PropertyDescriptor[] pds, Object bean, String beanName) throws BeansException {
        return this.optionalObjectsController.isDiscarded(beanName) ? null : pvs;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (this.optionalObjectsController.isDiscarded(beanName)) {
            if (this.beanFactory.containsBeanDefinition(beanName)) {
                this.beanFactory.removeBeanDefinition(beanName);
            }
            this.beanFactory.destroySingleton(beanName);
            return null;
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }
}

