/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.parsers.assembly;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.AnnotatedObject;
import org.mule.api.MuleContext;
import org.mule.config.spring.MuleArtifactContext;
import org.mule.config.spring.MuleHierarchicalBeanDefinitionParserDelegate;
import org.mule.config.spring.parsers.assembly.BeanAssembler;
import org.mule.config.spring.parsers.assembly.MapEntryCombiner;
import org.mule.config.spring.parsers.assembly.configuration.PropertyConfiguration;
import org.mule.config.spring.parsers.assembly.configuration.SingleProperty;
import org.mule.config.spring.parsers.assembly.configuration.SinglePropertyLiteral;
import org.mule.config.spring.parsers.assembly.configuration.SinglePropertyWrapper;
import org.mule.config.spring.parsers.collection.ChildListEntryDefinitionParser;
import org.mule.config.spring.parsers.collection.ChildMapEntryDefinitionParser;
import org.mule.config.spring.util.SpringXMLUtils;
import org.mule.util.ClassUtils;
import org.mule.util.MapCombiner;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.MapFactoryBean;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.w3c.dom.Attr;

public class DefaultBeanAssembler
implements BeanAssembler {
    private static Log logger = LogFactory.getLog(DefaultBeanAssembler.class);
    private PropertyConfiguration beanConfig;
    protected BeanDefinitionBuilder bean;
    protected PropertyConfiguration targetConfig;
    protected BeanDefinition target;

    public DefaultBeanAssembler(PropertyConfiguration beanConfig, BeanDefinitionBuilder bean, PropertyConfiguration targetConfig, BeanDefinition target) {
        this.beanConfig = beanConfig;
        this.bean = bean;
        this.targetConfig = targetConfig;
        this.target = target;
    }

    @Override
    public BeanDefinitionBuilder getBean() {
        return this.bean;
    }

    protected void setBean(BeanDefinitionBuilder bean) {
        this.bean = bean;
    }

    @Override
    public BeanDefinition getTarget() {
        return this.target;
    }

    protected PropertyConfiguration getBeanConfig() {
        return this.beanConfig;
    }

    protected PropertyConfiguration getTargetConfig() {
        return this.targetConfig;
    }

    @Override
    public void extendBean(Attr attribute) {
        AbstractBeanDefinition beanDefinition = this.bean.getBeanDefinition();
        String oldName = SpringXMLUtils.attributeName((Attr)attribute);
        String oldValue = attribute.getNodeValue();
        if (attribute.getNamespaceURI() == null) {
            if (!this.beanConfig.isIgnored(oldName)) {
                logger.debug((Object)(attribute + " for " + beanDefinition.getBeanClassName()));
                String newName = DefaultBeanAssembler.bestGuessName(this.beanConfig, oldName, beanDefinition.getBeanClassName());
                Object newValue = this.beanConfig.translateValue(oldName, oldValue);
                this.addPropertyWithReference(beanDefinition.getPropertyValues(), this.beanConfig.getSingleProperty(oldName), newName, newValue);
            }
        } else if (this.isAnnotationsPropertyAvailable(beanDefinition.getBeanClass())) {
            QName name = attribute.getPrefix() != null ? new QName(attribute.getNamespaceURI(), attribute.getLocalName(), attribute.getPrefix()) : new QName(attribute.getNamespaceURI(), attribute.getLocalName());
            Object value = this.beanConfig.translateValue(oldName, oldValue);
            this.addAnnotationValue(beanDefinition.getPropertyValues(), name, value);
            MuleContext muleContext = MuleArtifactContext.getCurrentMuleContext().get();
            if (muleContext != null) {
                Map annotations = muleContext.getConfigurationAnnotations();
                HashSet<Object> values = (HashSet<Object>)annotations.get(name);
                if (values == null) {
                    values = new HashSet<Object>();
                    annotations.put(name, values);
                }
                values.add(value);
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("Cannot assign " + beanDefinition.getBeanClass() + " to " + AnnotatedObject.class));
        }
    }

    public final boolean isAnnotationsPropertyAvailable(Class<?> beanClass) {
        try {
            return AnnotatedObject.class.isAssignableFrom(beanClass);
        }
        catch (Exception e) {
            return false;
        }
    }

    public final boolean isAnnotationsPropertyAvailable(String beanClassName) {
        try {
            return AnnotatedObject.class.isAssignableFrom(Class.forName(beanClassName));
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void extendBean(String newName, Object newValue, boolean isReference) {
        this.addPropertyWithReference(this.bean.getBeanDefinition().getPropertyValues(), new SinglePropertyLiteral(isReference), newName, newValue);
    }

    @Override
    public void extendTarget(Attr attribute) {
        String oldName = SpringXMLUtils.attributeName((Attr)attribute);
        String oldValue = attribute.getNodeValue();
        String newName = DefaultBeanAssembler.bestGuessName(this.targetConfig, oldName, this.bean.getBeanDefinition().getBeanClassName());
        Object newValue = this.targetConfig.translateValue(oldName, oldValue);
        this.addPropertyWithReference(this.target.getPropertyValues(), this.targetConfig.getSingleProperty(oldName), newName, newValue);
    }

    @Override
    public void extendTarget(String newName, Object newValue, boolean isReference) {
        this.assertTargetPresent();
        this.addPropertyWithReference(this.target.getPropertyValues(), new SinglePropertyLiteral(isReference), newName, newValue);
    }

    @Override
    public void extendTarget(String oldName, String newName, Object newValue) {
        this.assertTargetPresent();
        this.addPropertyWithReference(this.target.getPropertyValues(), new SinglePropertyWrapper(oldName, this.getTargetConfig()), newName, newValue);
    }

    @Override
    public void insertBeanInTarget(String oldName) {
        Object oldValue;
        logger.debug((Object)("insert " + this.bean.getBeanDefinition().getBeanClassName() + " -> " + this.target.getBeanClassName()));
        this.assertTargetPresent();
        String beanClass = this.bean.getBeanDefinition().getBeanClassName();
        MutablePropertyValues sourceProperties = this.bean.getRawBeanDefinition().getPropertyValues();
        String newName = DefaultBeanAssembler.bestGuessName(this.targetConfig, oldName, this.target.getBeanClassName());
        MutablePropertyValues targetProperties = this.target.getPropertyValues();
        PropertyValue pv = targetProperties.getPropertyValue(newName);
        Object object = oldValue = null == pv ? null : pv.getValue();
        if (!this.targetConfig.isIgnored(oldName)) {
            if (this.targetConfig.isCollection(oldName) || beanClass.equals(ChildListEntryDefinitionParser.ListEntry.class.getName())) {
                if (null == oldValue) {
                    if (beanClass.equals(ChildMapEntryDefinitionParser.KeyValuePair.class.getName()) || beanClass.equals(MapEntryCombiner.class.getName()) || beanClass.equals(MapFactoryBean.class.getName())) {
                        BeanDefinitionBuilder combiner = BeanDefinitionBuilder.rootBeanDefinition(MapCombiner.class);
                        targetProperties.addPropertyValue(newName, (Object)combiner.getBeanDefinition());
                        MutablePropertyValues combinerProperties = combiner.getBeanDefinition().getPropertyValues();
                        oldValue = new ManagedList();
                        pv = new PropertyValue("list", oldValue);
                        combinerProperties.addPropertyValue(pv);
                    } else {
                        oldValue = new ManagedList();
                        pv = new PropertyValue(newName, oldValue);
                        targetProperties.addPropertyValue(pv);
                    }
                }
                List list = DefaultBeanAssembler.retrieveList(oldValue);
                if (ChildMapEntryDefinitionParser.KeyValuePair.class.getName().equals(beanClass)) {
                    list.add(new ManagedMap());
                    DefaultBeanAssembler.retrieveMap(list.get(list.size() - 1)).put(sourceProperties.getPropertyValue("key").getValue(), sourceProperties.getPropertyValue("value").getValue());
                } else if (beanClass.equals(ChildListEntryDefinitionParser.ListEntry.class.getName())) {
                    list.add(sourceProperties.getPropertyValue("value").getValue());
                } else {
                    list.add(this.bean.getBeanDefinition());
                }
            } else if (ChildMapEntryDefinitionParser.KeyValuePair.class.getName().equals(beanClass)) {
                if (null == pv || null == oldValue) {
                    pv = new PropertyValue(newName, (Object)new ManagedMap());
                    targetProperties.addPropertyValue(pv);
                }
                DefaultBeanAssembler.retrieveMap(pv.getValue()).put(sourceProperties.getPropertyValue("key").getValue(), sourceProperties.getPropertyValue("value").getValue());
            } else {
                targetProperties.addPropertyValue(newName, (Object)this.bean.getBeanDefinition());
            }
        }
    }

    @Override
    public void insertSingletonBeanInTarget(String propertyName, String singletonName) {
        Object oldValue;
        String newName = DefaultBeanAssembler.bestGuessName(this.targetConfig, propertyName, this.target.getBeanClassName());
        MutablePropertyValues targetProperties = this.target.getPropertyValues();
        PropertyValue pv = targetProperties.getPropertyValue(newName);
        Object object = oldValue = null == pv ? null : pv.getValue();
        if (!this.targetConfig.isIgnored(propertyName)) {
            if (this.targetConfig.isCollection(propertyName)) {
                if (null == oldValue) {
                    oldValue = new ManagedList();
                    pv = new PropertyValue(newName, oldValue);
                    targetProperties.addPropertyValue(pv);
                }
                List list = DefaultBeanAssembler.retrieveList(oldValue);
                list.add(new RuntimeBeanReference(singletonName));
            } else {
                targetProperties.addPropertyValue(newName, (Object)new RuntimeBeanReference(singletonName));
            }
        }
    }

    protected void insertInTarget(String oldName) {
    }

    protected static List retrieveList(Object value) {
        if (value instanceof List) {
            return (List)value;
        }
        if (DefaultBeanAssembler.isDefinitionOf(value, MapCombiner.class)) {
            return (List)DefaultBeanAssembler.unpackDefinition(value, "list");
        }
        throw new ClassCastException("Collection not of expected type: " + value);
    }

    private static Map retrieveMap(Object value) {
        if (value instanceof Map) {
            return (Map)value;
        }
        if (DefaultBeanAssembler.isDefinitionOf(value, MapFactoryBean.class)) {
            return (Map)DefaultBeanAssembler.unpackDefinition(value, "sourceMap");
        }
        throw new ClassCastException("Map not of expected type: " + value);
    }

    private static boolean isDefinitionOf(Object value, Class clazz) {
        return value instanceof BeanDefinition && ((BeanDefinition)value).getBeanClassName().equals(clazz.getName());
    }

    private static Object unpackDefinition(Object definition, String name) {
        return ((BeanDefinition)definition).getPropertyValues().getPropertyValue(name).getValue();
    }

    @Override
    public void copyBeanToTarget() {
        logger.debug((Object)("copy " + this.bean.getBeanDefinition().getBeanClassName() + " -> " + this.target.getBeanClassName()));
        this.assertTargetPresent();
        MutablePropertyValues targetProperties = this.target.getPropertyValues();
        MutablePropertyValues beanProperties = this.bean.getBeanDefinition().getPropertyValues();
        for (int i = 0; i < beanProperties.size(); ++i) {
            PropertyValue propertyValue = beanProperties.getPropertyValues()[i];
            this.addPropertyWithoutReference(targetProperties, new SinglePropertyLiteral(), propertyValue.getName(), propertyValue.getValue());
        }
    }

    @Override
    public void setBeanFlag(String flag) {
        MuleHierarchicalBeanDefinitionParserDelegate.setFlag((BeanDefinition)this.bean.getRawBeanDefinition(), flag);
    }

    protected void assertTargetPresent() {
        if (null == this.target) {
            throw new IllegalStateException("Bean assembler does not have a target");
        }
    }

    public final void addAnnotationValue(MutablePropertyValues properties, QName name, Object value) {
        HashMap<QName, Object> oldValue;
        PropertyValue propertyValue = properties.getPropertyValue("annotations");
        if (propertyValue != null) {
            oldValue = (HashMap<QName, Object>)propertyValue.getValue();
        } else {
            oldValue = new HashMap<QName, Object>();
            properties.addPropertyValue("annotations", oldValue);
        }
        oldValue.put(name, value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void addPropertyWithReference(MutablePropertyValues properties, SingleProperty config, String name, Object value) {
        if (config.isIgnored()) return;
        if (config.isReference()) {
            if (!(value instanceof String)) throw new IllegalArgumentException("Bean reference must be a String: " + name + "/" + value);
            if (((String)value).trim().indexOf(" ") > -1) {
                config.setCollection();
            }
            StringTokenizer refs = new StringTokenizer((String)value);
            while (refs.hasMoreTokens()) {
                String ref = refs.nextToken();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("possible non-dependent reference: " + name + "/" + ref));
                }
                this.addPropertyWithoutReference(properties, config, name, new RuntimeBeanReference(ref));
            }
            return;
        } else {
            this.addPropertyWithoutReference(properties, config, name, value);
        }
    }

    protected void addPropertyWithoutReference(MutablePropertyValues properties, SingleProperty config, String name, Object value) {
        if (!config.isIgnored()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(name + ": " + value));
            }
            Object oldValue = null;
            if (properties.contains(name)) {
                oldValue = properties.getPropertyValue(name).getValue();
            }
            if (config.isCollection() || oldValue instanceof Collection || value instanceof Collection) {
                ManagedList values = new ManagedList();
                if (null != oldValue) {
                    properties.removePropertyValue(name);
                    if (oldValue instanceof Collection) {
                        values.addAll((Collection)oldValue);
                    } else {
                        values.add(oldValue);
                    }
                }
                if (value instanceof Collection) {
                    values.addAll((Collection)value);
                } else {
                    values.add(value);
                }
                properties.addPropertyValue(name, (Object)values);
            } else {
                properties.addPropertyValue(name, value);
            }
        }
    }

    protected static String bestGuessName(PropertyConfiguration config, String oldName, String className) {
        String newName = config.translateName(oldName);
        if (!DefaultBeanAssembler.methodExists(className, newName)) {
            String pluraly;
            String plural = newName + "s";
            if (DefaultBeanAssembler.methodExists(className, plural)) {
                config.addCollection(oldName);
                return plural;
            }
            if (newName.endsWith("y") && DefaultBeanAssembler.methodExists(className, pluraly = newName.substring(0, newName.length() - 1) + "ies")) {
                config.addCollection(oldName);
                return pluraly;
            }
        }
        return newName;
    }

    protected static boolean methodExists(String className, String newName) {
        try {
            Class clazz = ClassUtils.getClass((String)className);
            Method[] methods = clazz.getMethods();
            String setter = "set" + newName;
            for (int i = 0; i < methods.length; ++i) {
                if (!methods[i].getName().equalsIgnoreCase(setter)) continue;
                return true;
            }
        }
        catch (Exception e) {
            logger.debug((Object)("Could not access bean class " + className), (Throwable)e);
        }
        return false;
    }

    @Override
    public String resolvePlaceholder(String value) {
        MuleContext context = MuleArtifactContext.getCurrentMuleContext().get();
        String deploymentPropertyResolvedValue = this.getDeploymentPropertyResolvedValue(value, context);
        return deploymentPropertyResolvedValue;
    }

    private String getDeploymentPropertyResolvedValue(String value, MuleContext context) {
        String deploymentPropertyResolvedValue = null;
        if (this.isPlaceholder(value)) {
            deploymentPropertyResolvedValue = (String)context.getDeploymentProperties().get(this.extractName(value));
        }
        return deploymentPropertyResolvedValue;
    }

    private String extractName(String value) {
        return value.substring(value.indexOf("${") + 2, value.indexOf("}"));
    }

    private boolean isPlaceholder(String value) {
        return value.indexOf("${") != -1 && value.indexOf("}") != -1 && value.indexOf("${") < value.indexOf("}");
    }
}

