/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.parsers;

import org.mule.config.spring.parsers.AbstractMuleBeanDefinitionParser;
import org.mule.config.spring.parsers.assembly.BeanAssembler;
import org.mule.config.spring.parsers.assembly.configuration.PropertyConfiguration;
import org.mule.config.spring.parsers.assembly.configuration.ReusablePropertyConfiguration;
import org.mule.config.spring.parsers.assembly.configuration.TempWrapperPropertyConfiguration;
import org.mule.config.spring.util.SpringXMLUtils;
import org.mule.util.StringUtils;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public abstract class AbstractHierarchicalDefinitionParser
extends AbstractMuleBeanDefinitionParser {
    private ReusablePropertyConfiguration targetPropertyConfiguration;
    private BeanDefinition forcedParent;

    public AbstractHierarchicalDefinitionParser() {
        this.targetPropertyConfiguration = new ReusablePropertyConfiguration(new TempWrapperPropertyConfiguration(this.beanPropertyConfiguration, false));
        this.forcedParent = null;
    }

    public PropertyConfiguration getTargetPropertyConfiguration() {
        return this.targetPropertyConfiguration;
    }

    protected String getParentBeanName(Element element) {
        return ((Element)element.getParentNode()).getAttribute("name");
    }

    public BeanDefinition getParentBeanDefinition(Element element) {
        if (null != this.forcedParent) {
            return this.forcedParent;
        }
        String parentBean = this.getParentBeanName(element);
        if (StringUtils.isBlank((String)parentBean)) {
            throw new IllegalStateException("No parent for " + SpringXMLUtils.elementToString((Element)element));
        }
        return this.getRegistry().getBeanDefinition(parentBean);
    }

    @Override
    protected BeanAssembler getBeanAssembler(Element element, BeanDefinitionBuilder bean) {
        BeanDefinition target = this.getParentBeanDefinition(element);
        return this.getBeanAssemblerFactory().newBeanAssembler(this.beanPropertyConfiguration, bean, this.targetPropertyConfiguration, target);
    }

    protected BeanAssembler getOrphanBeanAssembler(Element element, BeanDefinitionBuilder bean) {
        return super.getBeanAssembler(element, bean);
    }

    public void forceParent(BeanDefinition parent) {
        this.forcedParent = parent;
    }

    @Override
    protected void preProcess(Element element) {
        super.preProcess(element);
        this.targetPropertyConfiguration.reset();
    }

    @Override
    protected void postProcess(ParserContext context, BeanAssembler assembler, Element element) {
        super.postProcess(context, assembler, element);
        this.forcedParent = null;
    }
}

