/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.factories;

import org.mule.api.config.ConfigurationException;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.EndpointFactory;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.schedule.SchedulerFactory;
import org.mule.config.i18n.MessageFactory;
import org.mule.config.spring.factories.InboundEndpointFactoryBean;
import org.mule.endpoint.URIBuilder;
import org.mule.transport.polling.MessageProcessorPollingOverride;
import org.mule.transport.polling.schedule.FixedFrequencySchedulerFactory;

public class PollingMessageSourceFactoryBean
extends InboundEndpointFactoryBean {
    protected SchedulerFactory<Runnable> schedulerFactory;
    protected MessageProcessor messageProcessor;
    protected MessageProcessorPollingOverride override;
    protected Long frequency;

    private FixedFrequencySchedulerFactory defaultSchedulerFactory() {
        FixedFrequencySchedulerFactory factory = new FixedFrequencySchedulerFactory();
        factory.setFrequency(this.frequency.longValue());
        factory.setMuleContext(this.muleContext);
        return factory;
    }

    @Override
    public Object doGetObject() throws Exception {
        this.uriBuilder = new URIBuilder("polling://" + this.hashCode(), this.muleContext);
        this.properties.put("MULE_ENDPOINT__sourceMessageProcessor", this.messageProcessor);
        this.properties.put("MULE_ENDPOINT__pollOverride", this.override);
        this.properties.put("MULE_ENDPOINT__schedulerFactory", this.schedulerFactory == null ? this.defaultSchedulerFactory() : this.schedulerFactory);
        this.properties.put("pollingFrequency", this.frequency);
        EndpointFactory ef = this.muleContext.getEndpointFactory();
        if (ef != null) {
            return ef.getInboundEndpoint((EndpointBuilder)this);
        }
        throw new ConfigurationException(MessageFactory.createStaticMessage((String)"EndpointFactory not found in Registry"));
    }

    public void setMessageProcessor(MessageProcessor messageProcessor) {
        this.messageProcessor = messageProcessor;
    }

    public void setOverride(MessageProcessorPollingOverride override) {
        this.override = override;
    }

    public void setFrequency(Long frequency) {
        this.frequency = frequency;
    }

    public void setSchedulerFactory(SchedulerFactory<Runnable> schedulerFactory) {
        this.schedulerFactory = schedulerFactory;
    }
}

