/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.spring.ElementValidator;
import org.mule.config.spring.util.SpringXMLUtils;
import org.mule.util.StringUtils;
import org.mule.util.xmlsecurity.XMLSecureFactories;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.ComponentDefinition;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.BeanDefinitionParserDelegate;
import org.springframework.beans.factory.xml.DefaultBeanDefinitionDocumentReader;
import org.springframework.beans.factory.xml.NamespaceHandler;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.beans.factory.xml.XmlReaderContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class MuleHierarchicalBeanDefinitionParserDelegate
extends BeanDefinitionParserDelegate {
    public static final String BEANS = "beans";
    public static final String MULE_REPEAT_PARSE = "org.mule.config.spring.MuleHierarchicalBeanDefinitionParserDelegate.MULE_REPEAT_PARSE";
    public static final String MULE_NO_RECURSE = "org.mule.config.spring.MuleHierarchicalBeanDefinitionParserDelegate.MULE_NO_RECURSE";
    public static final String MULE_FORCE_RECURSE = "org.mule.config.spring.MuleHierarchicalBeanDefinitionParserDelegate.MULE_FORCE_RECURSE";
    public static final String MULE_NO_REGISTRATION = "org.mule.config.spring.MuleHierarchicalBeanDefinitionParserDelegate.MULE_NO_REGISTRATION";
    public static final String MULE_POST_CHILDREN = "org.mule.config.spring.MuleHierarchicalBeanDefinitionParserDelegate.MULE_POST_CHILDREN";
    private DefaultBeanDefinitionDocumentReader spring;
    private final List<ElementValidator> elementValidators;
    protected static final Log logger = LogFactory.getLog(MuleHierarchicalBeanDefinitionParserDelegate.class);

    public MuleHierarchicalBeanDefinitionParserDelegate(XmlReaderContext readerContext, DefaultBeanDefinitionDocumentReader spring, ElementValidator ... elementValidators) {
        super(readerContext);
        this.spring = spring;
        this.elementValidators = ArrayUtils.isEmpty((Object[])elementValidators) ? ImmutableList.of() : ImmutableList.copyOf((Object[])elementValidators);
    }

    public BeanDefinition parseCustomElement(Element element, BeanDefinition parent) {
        BeanDefinition finalChild;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("parsing: " + SpringXMLUtils.elementToString((Element)element)));
        }
        this.validate(element);
        if (SpringXMLUtils.isBeansNamespace(element)) {
            return this.handleSpringElements(element, parent);
        }
        String namespaceUri = element.getNamespaceURI();
        NamespaceHandler handler = this.getReaderContext().getNamespaceHandlerResolver().resolve(namespaceUri);
        if (handler == null) {
            this.getReaderContext().error("Unable to locate NamespaceHandler for namespace [" + namespaceUri + "]", (Object)element);
            return null;
        }
        boolean noRecurse = false;
        boolean forceRecurse = false;
        do {
            ParserContext parserContext = new ParserContext(this.getReaderContext(), (BeanDefinitionParserDelegate)this, parent);
            finalChild = handler.parse(element, parserContext);
            this.registerBean(element, finalChild);
            noRecurse = noRecurse || MuleHierarchicalBeanDefinitionParserDelegate.testFlag(finalChild, MULE_NO_RECURSE);
            boolean bl = forceRecurse = forceRecurse || MuleHierarchicalBeanDefinitionParserDelegate.testFlag(finalChild, MULE_FORCE_RECURSE);
        } while (null != finalChild && MuleHierarchicalBeanDefinitionParserDelegate.testFlag(finalChild, MULE_REPEAT_PARSE));
        boolean isRecurse = noRecurse ? false : (forceRecurse ? true : SpringXMLUtils.isMuleNamespace(element));
        if (isRecurse) {
            NodeList list = element.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                if (!(list.item(i) instanceof Element)) continue;
                this.parseCustomElement((Element)list.item(i), finalChild);
            }
        }
        if (MuleHierarchicalBeanDefinitionParserDelegate.testFlag(finalChild, MULE_POST_CHILDREN)) {
            ParserContext parserContext = new ParserContext(this.getReaderContext(), (BeanDefinitionParserDelegate)this, parent);
            finalChild = handler.parse(element, parserContext);
        }
        return finalChild;
    }

    private void validate(Element element) {
        for (ElementValidator validator : this.elementValidators) {
            validator.validate(element);
        }
    }

    protected BeanDefinition handleSpringElements(Element element, BeanDefinition parent) {
        if (SpringXMLUtils.isLocalName((Element)element, (String)BEANS)) {
            try {
                DocumentBuilderFactory factory = XMLSecureFactories.createDefault().getDocumentBuilderFactory();
                Document doc = factory.newDocumentBuilder().newDocument();
                doc.appendChild(doc.importNode(element, true));
                this.spring.registerBeanDefinitions(doc, this.getReaderContext());
            }
            catch (ParserConfigurationException e) {
                throw new RuntimeException(e);
            }
            return parent;
        }
        if (SpringXMLUtils.isLocalName((Element)element, (String)"property")) {
            this.parsePropertyElement(element, parent);
            return parent;
        }
        if (SpringXMLUtils.isLocalName((Element)element, (String)"bean")) {
            BeanDefinitionHolder holder = this.parseBeanDefinitionElement(element, parent);
            this.registerBeanDefinitionHolder(holder);
            return holder.getBeanDefinition();
        }
        throw new IllegalStateException("Unexpected Spring element: " + SpringXMLUtils.elementToString((Element)element));
    }

    protected void registerBean(Element ele, BeanDefinition bd) {
        if (bd == null) {
            return;
        }
        if (!MuleHierarchicalBeanDefinitionParserDelegate.testFlag(bd, MULE_NO_REGISTRATION)) {
            String name = this.generateChildBeanName(ele);
            logger.debug((Object)("register " + name + ": " + bd.getBeanClassName()));
            this.registerBeanDefinitionHolder(new BeanDefinitionHolder(bd, name));
        }
    }

    protected void registerBeanDefinitionHolder(BeanDefinitionHolder bdHolder) {
        BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)bdHolder, (BeanDefinitionRegistry)this.getReaderContext().getRegistry());
        this.getReaderContext().fireComponentRegistered((ComponentDefinition)new BeanComponentDefinition(bdHolder));
    }

    protected String generateChildBeanName(Element e) {
        String id = SpringXMLUtils.getNameOrId(e);
        if (StringUtils.isBlank((String)id)) {
            String parentId = SpringXMLUtils.getNameOrId((Element)e.getParentNode());
            return "." + parentId + ":" + e.getLocalName();
        }
        return id;
    }

    public static void setFlag(BeanDefinition bean, String flag) {
        bean.setAttribute(flag, (Object)Boolean.TRUE);
    }

    public static boolean testFlag(BeanDefinition bean, String flag) {
        return null != bean && bean.hasAttribute(flag) && bean.getAttribute(flag) instanceof Boolean && (Boolean)bean.getAttribute(flag) != false;
    }

    public Map parseMapElement(Element mapEle, String mapElementTagName, String mapElementKeyAttributeName, String mapElementValueAttributeName) {
        List entryEles = DomUtils.getChildElementsByTagName((Element)mapEle, (String)mapElementTagName);
        ManagedMap map = new ManagedMap(entryEles.size());
        map.setSource(this.extractSource(mapEle));
        map.setMergeEnabled(this.parseMergeAttribute(mapEle));
        for (Element entryEle : entryEles) {
            Object key = this.buildTypedStringValueForMap(entryEle.getAttribute(mapElementKeyAttributeName), null, entryEle);
            Object value = this.buildTypedStringValueForMap(entryEle.getAttribute(mapElementValueAttributeName), null, entryEle);
            map.put(key, value);
        }
        return map;
    }
}

