/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.mule.runtime.api.service.Service;
import org.mule.runtime.api.service.ServiceDefinition;
import org.mule.runtime.api.service.ServiceProvider;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.module.service.ServiceProviderResolutionHelper;
import org.mule.runtime.module.service.ServiceResolutionError;
import org.mule.runtime.module.service.ServiceResolver;

public class ReflectionServiceResolver
implements ServiceResolver {
    private final ServiceProviderResolutionHelper serviceProviderResolutionHelper;

    public ReflectionServiceResolver(ServiceProviderResolutionHelper serviceProviderResolutionHelper) {
        Preconditions.checkArgument((serviceProviderResolutionHelper != null ? 1 : 0) != 0, (String)"serviceProviderResolutionHelper cannot be null");
        this.serviceProviderResolutionHelper = serviceProviderResolutionHelper;
    }

    @Override
    public List<Service> resolveServices(List<ServiceProvider> serviceProviders) throws ServiceResolutionError {
        List<DependencyAwareServiceProvider> dependencyAwareServiceProviders = this.createDependencyAwareServiceProviders(serviceProviders);
        LinkedHashMap<Class, ServiceDefinition> registeredServices = new LinkedHashMap<Class, ServiceDefinition>();
        LinkedList<DependencyAwareServiceProvider> unresolvedServiceProviders = new LinkedList<DependencyAwareServiceProvider>(dependencyAwareServiceProviders);
        LinkedList<DependencyAwareServiceProvider> resolvedServiceProviders = new LinkedList<DependencyAwareServiceProvider>();
        boolean continueResolution = true;
        while (continueResolution) {
            int initialResolvedCount = resolvedServiceProviders.size();
            LinkedList<DependencyAwareServiceProvider> pendingUnresolvedServices = new LinkedList<DependencyAwareServiceProvider>();
            for (DependencyAwareServiceProvider dependencyAwareServiceProvider : unresolvedServiceProviders) {
                if (this.isResolvedService(dependencyAwareServiceProvider, registeredServices.values())) {
                    this.serviceProviderResolutionHelper.injectInstance(dependencyAwareServiceProvider.serviceProvider, registeredServices.values());
                    for (ServiceDefinition serviceDefinition : dependencyAwareServiceProvider.providedServices()) {
                        registeredServices.put(serviceDefinition.getServiceClass(), serviceDefinition);
                    }
                    resolvedServiceProviders.add(dependencyAwareServiceProvider);
                    continue;
                }
                pendingUnresolvedServices.add(dependencyAwareServiceProvider);
            }
            unresolvedServiceProviders = pendingUnresolvedServices;
            continueResolution = resolvedServiceProviders.size() > initialResolvedCount;
        }
        if (unresolvedServiceProviders.size() != 0) {
            throw new ServiceResolutionError("Unable to resolve core service dependencies: " + unresolvedServiceProviders);
        }
        return registeredServices.values().stream().map(s -> s.getService()).collect(Collectors.toList());
    }

    private List<DependencyAwareServiceProvider> createDependencyAwareServiceProviders(List<ServiceProvider> serviceProviders) {
        ArrayList<DependencyAwareServiceProvider> result = new ArrayList<DependencyAwareServiceProvider>(serviceProviders.size());
        for (ServiceProvider serviceProvider : serviceProviders) {
            result.add(new DependencyAwareServiceProvider(serviceProvider, this.serviceProviderResolutionHelper.findServiceDependencies(serviceProvider)));
        }
        result.sort((p1, p2) -> p1.getClass().getName().compareTo(p2.getClass().getName()));
        return result;
    }

    private boolean isResolvedService(DependencyAwareServiceProvider dependencyAwareServiceProvider, Collection<ServiceDefinition> resolvedServices) {
        boolean resolvedCoreExtension = dependencyAwareServiceProvider.dependencies.isEmpty();
        if (!resolvedCoreExtension && this.satisfiedDependencies(dependencyAwareServiceProvider.dependencies, resolvedServices)) {
            resolvedCoreExtension = true;
        }
        return resolvedCoreExtension;
    }

    private boolean satisfiedDependencies(List<Class<? extends Service>> dependencies, Collection<ServiceDefinition> resolvedServices) {
        boolean resolvedDependency = true;
        for (Class<? extends Service> dependency : dependencies) {
            resolvedDependency = false;
            for (ServiceDefinition registeredService : resolvedServices) {
                if (!registeredService.getServiceClass().isAssignableFrom(dependency)) continue;
                resolvedDependency = true;
            }
            if (resolvedDependency) continue;
            break;
        }
        return resolvedDependency;
    }

    private final class DependencyAwareServiceProvider
    implements ServiceProvider {
        private final ServiceProvider serviceProvider;
        private final List<Class<? extends Service>> dependencies;

        DependencyAwareServiceProvider(ServiceProvider serviceProvider, List<Class<? extends Service>> dependencies) {
            this.serviceProvider = serviceProvider;
            this.dependencies = dependencies;
        }

        public List<ServiceDefinition> providedServices() {
            return this.serviceProvider.providedServices();
        }

        List<Class<? extends Service>> getDependencies() {
            return this.dependencies;
        }
    }
}

