/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.service;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.service.Service;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.util.ClassUtils;

public class LifecycleFilterServiceProxy
implements InvocationHandler {
    private final Service service;

    public LifecycleFilterServiceProxy(Service service) {
        Preconditions.checkArgument((service != null ? 1 : 0) != 0, (String)"service cannot be null");
        this.service = service;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getDeclaringClass() == Startable.class || method.getDeclaringClass() == Stoppable.class) {
            throw new UnsupportedOperationException("Cannot invoke lifecycle methods on a service instance");
        }
        return method.invoke((Object)this.service, args);
    }

    public static Service createServiceProxy(Service service) {
        Preconditions.checkArgument((service != null ? 1 : 0) != 0, (String)"service cannot be null");
        LifecycleFilterServiceProxy handler = new LifecycleFilterServiceProxy(service);
        return (Service)Proxy.newProxyInstance(service.getClass().getClassLoader(), ClassUtils.findImplementedInterfaces(service.getClass()), (InvocationHandler)handler);
    }
}

