/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.scripting.filter;

import javax.script.Bindings;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.DefaultEventContext;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.EventContext;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.core.api.routing.filter.Filter;
import org.mule.runtime.core.processor.AbstractFilteringMessageProcessor;
import org.mule.runtime.module.scripting.component.Scriptable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptFilter
extends AbstractFilteringMessageProcessor
implements Filter,
Initialisable,
Disposable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScriptFilter.class);
    private Scriptable script;
    private String name;

    public void initialise() throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded((Object)this.script, (MuleContext)this.muleContext);
    }

    public void dispose() {
        LifecycleUtils.disposeIfNeeded((Object)this.script, (Logger)LOGGER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean accept(Event event, Event.Builder builder) {
        Bindings bindings = this.script.getScriptEngine().createBindings();
        this.script.populateBindings(bindings, event, builder);
        try {
            boolean bl = (Boolean)this.script.runScript(bindings);
            return bl;
        }
        catch (Throwable e) {
            boolean bl = false;
            return bl;
        }
        finally {
            builder.message((Message)((InternalMessage)bindings.get("message")));
        }
    }

    public boolean accept(InternalMessage message, Event.Builder builder) {
        Bindings bindings = this.script.getScriptEngine().createBindings();
        Flow flow = Flow.builder((String)"ScriptFilterFlow", (MuleContext)this.muleContext).build();
        Event event = Event.builder((EventContext)DefaultEventContext.create((FlowConstruct)flow, (String)"ScriptFilter")).message((Message)message).flow((FlowConstruct)flow).build();
        this.script.populateBindings(bindings, event, builder);
        try {
            return (Boolean)this.script.runScript(bindings);
        }
        catch (Throwable e) {
            return false;
        }
    }

    public Scriptable getScript() {
        return this.script;
    }

    public void setScript(Scriptable script) {
        this.script = script;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

