/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.scripting.transformer;

import java.nio.charset.Charset;
import javax.script.Bindings;
import javax.script.ScriptException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.transformer.AbstractMessageTransformer;
import org.mule.runtime.module.scripting.component.Scriptable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptTransformer
extends AbstractMessageTransformer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScriptTransformer.class);
    private Scriptable script;

    public void initialise() throws InitialisationException {
        super.initialise();
        LifecycleUtils.initialiseIfNeeded((Object)this.script, (MuleContext)this.muleContext);
    }

    public void dispose() {
        super.dispose();
        LifecycleUtils.disposeIfNeeded((Object)this.script, (Logger)LOGGER);
    }

    public Object transformMessage(Event event, Charset outputEncoding) throws TransformerException {
        Bindings bindings = this.script.getScriptEngine().createBindings();
        this.script.populateBindings(bindings, event, Event.builder((Event)event));
        try {
            Object object = this.script.runScript(bindings);
            return object;
        }
        catch (ScriptException e) {
            throw new TransformerException((Transformer)this, (Throwable)e);
        }
        finally {
            bindings.clear();
        }
    }

    public Scriptable getScript() {
        return this.script;
    }

    public void setScript(Scriptable script) {
        this.script = script;
    }
}

