/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.catalog.model.resolver;

import com.google.common.base.Preconditions;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.annotation.TypeIdAnnotation;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.impl.BaseMetadataType;
import org.mule.metadata.json.JsonTypeLoader;
import org.mule.runtime.extension.internal.loader.catalog.model.resolver.TypeResolver;

public class SingleTypeResolver
implements TypeResolver {
    private String typeIdentifier;
    private final TypeLoader typeLoader;

    public SingleTypeResolver(String typeIdentifier, URL schemaUrl) {
        Preconditions.checkNotNull((Object)typeIdentifier);
        Preconditions.checkNotNull((Object)schemaUrl);
        this.typeLoader = new JsonTypeLoader(FileUtils.toFile((URL)schemaUrl));
        this.typeIdentifier = typeIdentifier;
    }

    @Override
    public Optional<MetadataType> resolveType(String typeIdentifier) {
        return this.typeIdentifier.equals(typeIdentifier) ? this.getTypeWhileAddingIDToMakeItSerializable(typeIdentifier) : Optional.empty();
    }

    private Optional<MetadataType> getTypeWhileAddingIDToMakeItSerializable(String typeIdentifier) {
        Optional load = this.typeLoader.load(typeIdentifier);
        load.ifPresent(metadataType -> {
            if (metadataType instanceof ObjectType) {
                try {
                    Field annotationsField = BaseMetadataType.class.getDeclaredField("annotations");
                    annotationsField.setAccessible(true);
                    Map mapa = (Map)annotationsField.get(metadataType);
                    mapa.put(TypeIdAnnotation.class, new TypeIdAnnotation(typeIdentifier));
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    e.printStackTrace();
                    throw new RuntimeException("this code must be removed", e);
                }
            }
        });
        return load;
    }
}

